/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.internal.docker.ui.DockerConnectionWatcher;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DanglingImagesViewerFilter;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesComparator;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.IntermediateImagesViewerFilter;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelProviderUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.SpecialColumnLabelProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DockerImagesView
extends ViewPart
implements IDockerImageListener,
ISelectionListener,
ITabbedPropertySheetPageContributor,
IDockerConnectionManagerListener {
    public static final String VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerImagesView";
    private static final String TOGGLE_STATE = "org.eclipse.ui.commands.toggleState";
    private static final String SHOW_ALL_IMAGES_COMMAND_ID = "org.eclipse.linuxtools.docker.ui.commands.showAllImages";
    private static final String SHOW_ALL_IMAGES_PREFERENCE = "showAllImages";
    private static final String NoConnectionSelected = "ViewerNoConnectionSelected.msg";
    private static final String ConnectionNotAvailable = "ViewerConnectionNotAvailable.msg";
    private static final String ViewAllTitle = "ImagesViewTitle.all.msg";
    private static final String ViewFilteredTitle = "ImagesViewTitle.filtered.msg";
    private Form form;
    private Text search;
    private TableViewer viewer;
    private IDockerConnection connection;
    private final DanglingImagesViewerFilter hideDanglingImagesFilter = new DanglingImagesViewerFilter();
    private final IntermediateImagesViewerFilter hideIntermediateImagesFilter = new IntermediateImagesViewerFilter();

    public void setFocus() {
    }

    public void dispose() {
        if (this.connection != null) {
            this.connection.removeImageListener((IDockerImageListener)this);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        DockerConnectionManager.getInstance().removeConnectionManagerListener((IDockerConnectionManagerListener)this);
        super.dispose();
    }

    public String getContributorId() {
        return "org.eclipse.linuxtools.docker.ui.propertiesViewContributor";
    }

    public String getFormTitle() {
        return this.form.getText();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return (T)new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return (T)super.getAdapter(adapter);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        this.form.setText(DVMessages.getString(NoConnectionSelected));
        Composite container = this.form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        this.createTableViewer(container);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        this.hookContextMenu();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        boolean showAll = preferences.getBoolean(SHOW_ALL_IMAGES_PREFERENCE, false);
        this.showAllImages(showAll);
        ICommandService service = (ICommandService)this.getViewSite().getWorkbenchWindow().getService(ICommandService.class);
        service.getCommand(SHOW_ALL_IMAGES_COMMAND_ID).getState(TOGGLE_STATE).setValue((Object)showAll);
        service.refreshElements(SHOW_ALL_IMAGES_COMMAND_ID, null);
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        if (selection != null) {
            this.selectionChanged(null, selection);
            DockerConnectionWatcher.getInstance().selectionChanged(null, selection);
        }
    }

    private void createTableViewer(Composite container) {
        this.search = new Text(container, 640);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.search);
        this.search.addModifyListener(this.onSearch());
        Composite tableArea = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(tableArea);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableArea);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableArea.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableArea, 66306);
        this.viewer.setContentProvider((IContentProvider)new DockerImagesContentProvider());
        Table table = this.viewer.getTable();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo((Composite)table);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn idColumn = this.createColumn(DVMessages.getString("ID"));
        this.setLayout(idColumn, tableLayout, 150);
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerImage) {
                    String imageId = ((IDockerImage)element).id();
                    if (imageId.startsWith("sha256:")) {
                        imageId = imageId.substring(7);
                    }
                    if (imageId.length() > 12) {
                        return imageId.substring(0, 12);
                    }
                    return imageId;
                }
                return super.getText(element);
            }
        });
        TableViewerColumn tagsColumn = this.createColumn(DVMessages.getString("TAGS"));
        this.setLayout(tagsColumn, tableLayout, 150);
        tagsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof IDockerImage) {
                    void image;
                    IDockerImage iDockerImage = (IDockerImage)object;
                    IDockerImage cfr_ignored_0 = (IDockerImage)object;
                    StringBuilder messageBuilder = new StringBuilder();
                    Iterator iterator = image.repoTags().iterator();
                    while (iterator.hasNext()) {
                        String repoTag = (String)iterator.next();
                        messageBuilder.append(repoTag);
                        if (!iterator.hasNext()) continue;
                        messageBuilder.append('\n');
                    }
                    return messageBuilder.toString();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn creationDateColumn = this.createColumn(DVMessages.getString("CREATED"));
        this.setLayout(creationDateColumn, tableLayout, 150);
        creationDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerImage) {
                    return LabelProviderUtils.toCreatedDate(Long.parseLong(((IDockerImage)element).created()));
                }
                return super.getText(element);
            }
        });
        TableViewerColumn virtsizeColumn = this.createColumn(DVMessages.getString("VIRTSIZE"));
        this.setLayout(virtsizeColumn, tableLayout, 150);
        virtsizeColumn.setLabelProvider((CellLabelProvider)new SpecialColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerImage) {
                    Long size = ((IDockerImage)element).virtualSize();
                    if (size <= 0L) {
                        return "0";
                    }
                    String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
                    int digitGroups = (int)(Math.log10(size.longValue()) / Math.log10(1000.0));
                    return new DecimalFormat("#,##0.#").format((double)size.longValue() / Math.pow(1000.0, digitGroups)) + " " + units[digitGroups];
                }
                return super.getText(element);
            }

            @Override
            public String getCompareText(Object element) {
                if (element instanceof IDockerImage) {
                    return new DecimalFormat("000000000000000000000000").format(((IDockerImage)element).virtualSize());
                }
                return super.getText(element);
            }
        });
        DockerImagesComparator comparator = new DockerImagesComparator(this.viewer);
        comparator.setColumn(creationDateColumn.getColumn());
        comparator.setColumn(creationDateColumn.getColumn());
        this.viewer.setComparator((ViewerComparator)comparator);
        this.viewer.addFilter(this.getImagesFilter());
        this.setConnection(CommandUtils.getCurrentConnection(null));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private TableViewerColumn createColumn(String title) {
        TableViewerColumn propertyColumn = new TableViewerColumn(this.viewer, 2048);
        propertyColumn.getColumn().setText(title);
        propertyColumn.getColumn().addSelectionListener(this.onColumnSelected());
        return propertyColumn;
    }

    private SelectionListener onColumnSelected() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            TableColumn sortColumn = (TableColumn)e.getSource();
            DockerImagesComparator comparator = (DockerImagesComparator)this.viewer.getComparator();
            comparator.setColumn(sortColumn);
            this.viewer.refresh();
        });
    }

    private void setLayout(TableViewerColumn viewerColumn, TableColumnLayout tableLayout, int weight) {
        tableLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    private ModifyListener onSearch() {
        return e -> {
            if (this.viewer != null) {
                this.viewer.refresh();
                this.refreshViewTitle();
            }
        };
    }

    private ViewerFilter getImagesFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDockerImage) {
                    return element.toString().contains(DockerImagesView.this.search.getText());
                }
                return false;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            this.setConnection(null);
            return;
        }
        Object firstSegment = treeSelection.getPaths()[0].getFirstSegment();
        Object object = firstSegment;
        if (object instanceof IDockerConnection) {
            void connection;
            IDockerConnection iDockerConnection = (IDockerConnection)object;
            IDockerConnection cfr_ignored_0 = (IDockerConnection)object;
            this.setConnection((IDockerConnection)connection);
        }
    }

    public void listChanged(IDockerConnection connection, List<IDockerImage> images) {
        if (connection.getName().equals(connection.getName())) {
            Display.getDefault().asyncExec(() -> {
                if (this.viewer != null && !this.viewer.getTable().isDisposed()) {
                    this.viewer.refresh();
                    this.refreshViewTitle();
                }
            });
        }
    }

    private void refreshViewTitle() {
        if (this.viewer == null || this.viewer.getControl().isDisposed() || this.form == null || this.connection == null) {
            return;
        }
        if (this.connection.getState() == EnumDockerConnectionState.CLOSED) {
            this.form.setText(DVMessages.getFormattedString(ConnectionNotAvailable, this.connection.getName()));
            this.form.setEnabled(false);
        } else if (!this.connection.isImagesLoaded()) {
            this.form.setEnabled(false);
            this.form.setText(this.connection.getName());
        } else {
            List<ViewerFilter> filters = Arrays.asList(this.viewer.getFilters());
            if (filters.contains((Object)this.hideDanglingImagesFilter) || filters.contains((Object)this.hideIntermediateImagesFilter)) {
                this.form.setText(DVMessages.getFormattedString(ViewFilteredTitle, this.connection.getName(), Integer.toString(this.viewer.getTable().getItemCount()), Integer.toString(this.connection.getImages().size())));
            } else {
                this.form.setText(DVMessages.getFormattedString(ViewAllTitle, this.connection.getName(), Integer.toString(this.connection.getImages().size())));
            }
            this.form.setEnabled(true);
        }
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    private void setConnection(final IDockerConnection connection) {
        if (connection != null && connection.equals(this.connection)) {
            return;
        }
        if (this.connection != null) {
            this.connection.removeImageListener((IDockerImageListener)this);
        }
        this.connection = connection;
        if (this.viewer != null && this.connection != null) {
            Job refreshJob = new Job(DVMessages.getString("ImagesRefresh.msg")){

                protected IStatus run(IProgressMonitor monitor) {
                    connection.getImages(true);
                    connection.addImageListener((IDockerImageListener)DockerImagesView.this);
                    Display.getDefault().asyncExec(() -> {
                        if (!DockerImagesView.this.viewer.getControl().isDisposed()) {
                            DockerImagesView.this.viewer.setInput((Object)connection);
                            DockerImagesView.this.refreshViewTitle();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            refreshJob.schedule();
        } else if (this.viewer != null) {
            this.viewer.setInput((Object)new IDockerContainer[0]);
            this.form.setText(DVMessages.getString(NoConnectionSelected));
        }
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.viewer != null) {
            return this.viewer.getStructuredSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void showAllImages(boolean enabled) {
        if (!enabled) {
            this.viewer.addFilter((ViewerFilter)this.hideDanglingImagesFilter);
            this.viewer.addFilter((ViewerFilter)this.hideIntermediateImagesFilter);
        } else {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                ViewerFilter viewerFilter = (ViewerFilter)iterator.next();
                if (!viewerFilter.equals((Object)this.hideDanglingImagesFilter) && !viewerFilter.equals((Object)this.hideIntermediateImagesFilter)) continue;
                iterator.remove();
            }
            this.viewer.setFilters(filters.toArray(new ViewerFilter[0]));
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        preferences.putBoolean(SHOW_ALL_IMAGES_PREFERENCE, enabled);
        this.refreshViewTitle();
    }

    public void changeEvent(final IDockerConnection connection, int type) {
        if (type == 3) {
            Job refreshJob = new Job(DVMessages.getString("ImagesRefresh.msg")){

                protected IStatus run(IProgressMonitor monitor) {
                    connection.getImages(true);
                    return Status.OK_STATUS;
                }
            };
            refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(() -> DockerImagesView.this.refreshViewTitle());
                }
            });
            refreshJob.schedule();
        } else if (type == 2) {
            Display.getDefault().asyncExec(() -> this.refreshViewTitle());
        }
    }
}

