/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.AbstractRegistry;
import org.eclipse.linuxtools.docker.core.DockerCertificateException;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerOperationCancelledException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.DefaultImagePullProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePull;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PullImageCommandHandler
extends AbstractHandler {
    private static final String PULL_IMAGE_JOB_TITLE = "ImagePull.title";
    private static final String PULL_IMAGE_JOB_TASK = "ImagePull.msg";
    private static final String ERROR_PULLING_IMAGE = "ImagePullError.msg";
    private static final String ERROR_PULLING_IMAGE_NO_CONNECTION = "command.pullImage.failure.no_connection";
    private static final String MISSING_CONNECTION = "missing_connection";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        if (connection == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getString(MISSING_CONNECTION), (String)CommandMessages.getString(ERROR_PULLING_IMAGE_NO_CONNECTION));
        } else {
            ImagePull wizard = new ImagePull(connection);
            boolean pullImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (pullImage) {
                this.performPullImage(connection, wizard.getSelectedImageName(), (AbstractRegistry)wizard.getSelectedRegistryAccount());
            }
        }
        return null;
    }

    private void performPullImage(final IDockerConnection connection, final String imageName, final AbstractRegistry registry) {
        Job pullImageJob = new Job(DVMessages.getFormattedString(PULL_IMAGE_JOB_TITLE, imageName)){

            /*
             * Loose catch block
             * WARNING - void declaration
             */
            protected IStatus run(IProgressMonitor monitor) {
                DockerConnection dconn = (DockerConnection)connection;
                monitor.beginTask(DVMessages.getString(PullImageCommandHandler.PULL_IMAGE_JOB_TASK), -1);
                try {
                    try {
                        if (registry == null || registry.isDockerHubRegistry()) {
                            dconn.pullImage(imageName, (IDockerProgressHandler)new DefaultImagePullProgressHandler(connection, imageName, monitor));
                        } else {
                            String fullImageName = registry.getServerHost() + "/" + imageName;
                            AbstractRegistry abstractRegistry = registry;
                            if (abstractRegistry instanceof IRegistryAccount) {
                                void account;
                                IRegistryAccount iRegistryAccount = (IRegistryAccount)abstractRegistry;
                                IRegistryAccount cfr_ignored_0 = (IRegistryAccount)abstractRegistry;
                                dconn.pullImageWithHandler(fullImageName, (IRegistryAccount)account, (IDockerProgressHandler)new DefaultImagePullProgressHandler(connection, fullImageName, monitor));
                            } else {
                                dconn.pullImage(fullImageName, (IDockerProgressHandler)new DefaultImagePullProgressHandler(connection, fullImageName, monitor));
                            }
                        }
                    }
                    catch (DockerOperationCancelledException fullImageName) {
                        monitor.done();
                    }
                    catch (InterruptedException | DockerCertificateException fullImageName) {
                        monitor.done();
                    }
                    catch (DockerException e) {
                        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(PullImageCommandHandler.ERROR_PULLING_IMAGE, imageName), (String)e.getMessage()));
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        pullImageJob.schedule();
    }
}

