/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.help.internal.base.HelpApplication;
import org.eclipse.swt.widgets.Display;

public class HelpUIEventLoop {
    private static boolean started = false;
    private static boolean running = false;
    private static Display display;

    public static void run() {
        try {
            if (display == null) {
                display = Display.getCurrent();
            }
            if (display == null) {
                display = new Display();
            }
        }
        finally {
            started = true;
        }
        try {
            running = true;
            while (HelpApplication.isRunning()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Throwable t) {
                    ILog.of(HelpUIEventLoop.class).error(t.getMessage(), t);
                }
            }
            display.dispose();
            display = null;
        }
        finally {
            running = false;
        }
    }

    public static void wakeup() {
        Display d = display;
        if (d != null) {
            try {
                d.wake();
            }
            catch (Exception exception) {}
        }
    }

    public static void waitFor() {
        while (!started && HelpApplication.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isRunning() {
        return running;
    }
}

