/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.subscriber;

import java.lang.reflect.Field;
import java.security.AccessController;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.subscriber.ISubscriberProvider;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class TeamSubscriberProvider
implements ISubscriberProvider {
    @Override
    public Subscriber getSubscriber(ICompareContainer container, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        if (container instanceof ModelCompareEditorInput) {
            return this.getSubscriber((ModelCompareEditorInput)container);
        }
        return null;
    }

    private Subscriber getSubscriber(ModelCompareEditorInput input) {
        ModelSynchronizeParticipant participant = this.getModelSynchronizeParticipant(input);
        return participant != null && participant.getContext() instanceof SubscriberMergeContext ? ((SubscriberMergeContext)participant.getContext()).getSubscriber() : null;
    }

    private ModelSynchronizeParticipant getModelSynchronizeParticipant(ModelCompareEditorInput modelInput) {
        try {
            Field field = ModelCompareEditorInput.class.getDeclaredField("participant");
            AccessController.doPrivileged(() -> {
                field.setAccessible(true);
                return null;
            });
            Object participant = field.get(modelInput);
            return participant instanceof ModelSynchronizeParticipant ? (ModelSynchronizeParticipant)participant : null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            return null;
        }
    }
}

