/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingUnitSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingUnitSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.UnitMappingTable;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.StubCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HorizontalAuditClassMapping
extends AbstractHorizontalClassMapping
implements IClassMappingAuditSupport,
IClassMappingDeltaSupport,
IClassMappingUnitSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalAuditClassMapping.class);
    private static final ContextTracer TRACER_UNITS = new ContextTracer(OM.DEBUG_UNITS, HorizontalAuditClassMapping.class);
    private String sqlInsertAttributes;
    private String sqlSelectAttributesCurrent;
    private String sqlSelectAttributesByTime;
    private String sqlSelectAttributesByVersion;
    private String sqlSelectUnitByTime;
    private String sqlSelectAllObjectIDs;
    private String sqlReviseAttributes;
    private String sqlRawDeleteAttributes;

    public HorizontalAuditClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
    }

    @Override
    protected void initSQLStrings() {
        super.initSQLStrings();
        String[] strings = this.buildSQLSelects(false);
        String sqlSelectAttributesPrefix = strings[0];
        this.sqlSelectAttributesCurrent = strings[1];
        this.sqlSelectAttributesByTime = strings[2];
        StringBuilder builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("ABS(");
        builder.append(this.versionField);
        builder.append(")=?");
        this.sqlSelectAttributesByVersion = builder.toString();
        InternalRepository repository = (InternalRepository)this.getMappingStrategy().getStore().getRepository();
        if (repository.isSupportingUnits()) {
            strings = this.buildSQLSelects(true);
            this.sqlSelectUnitByTime = strings[2];
        }
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append("(");
        builder.append(this.idField);
        builder.append(", ");
        builder.append(this.versionField);
        builder.append(", ");
        builder.append(this.createdField);
        builder.append(", ");
        builder.append(this.revisedField);
        builder.append(", ");
        builder.append(this.resourceField);
        builder.append(", ");
        builder.append(this.containerField);
        builder.append(", ");
        builder.append(this.featureField);
        HorizontalAuditClassMapping.appendTypeMappingNames(builder, this.getValueMappings());
        HorizontalAuditClassMapping.appendFieldNames(builder, this.getUnsettableFields());
        HorizontalAuditClassMapping.appendFieldNames(builder, this.getListSizeFields());
        builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?");
        HorizontalAuditClassMapping.appendTypeMappingParameters(builder, this.getValueMappings());
        HorizontalAuditClassMapping.appendFieldParameters(builder, this.getUnsettableFields());
        HorizontalAuditClassMapping.appendFieldParameters(builder, this.getListSizeFields());
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.revisedField);
        builder.append("=? WHERE ");
        builder.append(this.idField);
        builder.append("=? AND ");
        builder.append(this.revisedField);
        builder.append("=0");
        this.sqlReviseAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append(this.idField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.revisedField);
        builder.append("=0");
        this.sqlSelectAllObjectIDs = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.idField);
        builder.append("=? AND ");
        builder.append(this.versionField);
        builder.append("=?");
        this.sqlRawDeleteAttributes = builder.toString();
    }

    @Override
    protected void appendSelectForHandleFields(StringBuilder builder) {
        builder.append(", ");
        builder.append(this.createdField);
        builder.append(", ");
        builder.append(this.revisedField);
    }

    private String[] buildSQLSelects(boolean forUnits) {
        String[] strings = new String[3];
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (forUnits) {
            builder.append(this.idField);
            builder.append(", ");
        }
        builder.append(this.versionField);
        builder.append(", ");
        builder.append(this.createdField);
        builder.append(", ");
        builder.append(this.revisedField);
        builder.append(", ");
        builder.append(this.resourceField);
        builder.append(", ");
        builder.append(this.containerField);
        builder.append(", ");
        builder.append(this.featureField);
        HorizontalAuditClassMapping.appendTypeMappingNames(builder, this.getValueMappings());
        HorizontalAuditClassMapping.appendFieldNames(builder, this.getUnsettableFields());
        HorizontalAuditClassMapping.appendFieldNames(builder, this.getListSizeFields());
        builder.append(" FROM ");
        builder.append(this.getTable());
        if (forUnits) {
            UnitMappingTable units = ((DBStore)this.getMappingStrategy().getStore()).getUnitMappingTable();
            builder.append(", ");
            builder.append((Object)units);
            builder.append(" WHERE ");
            builder.append(this.idField);
            builder.append("=");
            builder.append((Object)units);
            builder.append(".");
            builder.append(units.elem());
            builder.append(" AND ");
            builder.append((Object)units);
            builder.append(".");
            builder.append(units.unit());
            builder.append("=?");
            builder.append(" AND ");
        } else {
            builder.append(" WHERE ");
            builder.append(this.idField);
            builder.append("=? AND ");
        }
        strings[0] = builder.toString();
        builder.append(this.revisedField);
        builder.append("=0");
        if (forUnits) {
            builder.append(" ORDER BY ");
            builder.append(this.idField);
        }
        strings[1] = builder.toString();
        builder = new StringBuilder(strings[0]);
        builder.append("(");
        builder.append(this.createdField);
        builder.append("<=? AND (");
        builder.append(this.revisedField);
        builder.append("=0 OR ");
        builder.append(this.revisedField);
        builder.append(">=?))");
        if (forUnits) {
            builder.append(" AND ");
            builder.append(this.versionField);
            builder.append(">0");
            builder.append(" ORDER BY ");
            builder.append(this.idField);
        }
        strings[2] = builder.toString();
        return strings;
    }

    @Override
    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        boolean bl;
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = null;
        try {
            long timeStamp = revision.getTimeStamp();
            if (timeStamp != 0L) {
                stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectAttributesByTime, IDBPreparedStatement.ReuseProbability.MEDIUM);
                idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
                stmt.setLong(2, timeStamp);
                stmt.setLong(3, timeStamp);
            } else {
                stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectAttributesCurrent, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
            }
            boolean success = this.readValuesFromStatement((PreparedStatement)stmt, revision, accessor);
            if (success && revision.getVersion() >= 1) {
                this.readLists(accessor, revision, listChunk);
            }
            bl = success;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                throw throwable;
            }
        }
        DBUtil.close((Statement)stmt);
        return bl;
    }

    @Override
    public boolean readRevisionByVersion(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectAttributesByVersion, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
            stmt.setInt(2, revision.getVersion());
            boolean success = this.readValuesFromStatement((PreparedStatement)stmt, revision, accessor);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            return bl;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public IDBPreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, CDOBranchPoint branchPoint) {
        if (this.getTable() == null) {
            return null;
        }
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        long timeStamp = branchPoint.getTimeStamp();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.idField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.versionField);
        builder.append(">0 AND ");
        builder.append(this.containerField);
        builder.append("=? AND ");
        builder.append(nameValueMapping.getField());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? "=? " : " LIKE ? ");
        }
        builder.append(" AND (");
        if (timeStamp == 0L) {
            builder.append(this.revisedField);
            builder.append("=0)");
        } else {
            builder.append(this.createdField);
            builder.append("<=? AND (");
            builder.append(this.revisedField);
            builder.append("=0 OR ");
            builder.append(this.revisedField);
            builder.append(">=?))");
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            int column = 1;
            idHandler.setCDOID((PreparedStatement)stmt, column++, folderId);
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue((PreparedStatement)stmt, column++, queryName);
            }
            if (timeStamp != 0L) {
                stmt.setLong(column++, timeStamp);
                stmt.setLong(column++, timeStamp);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{stmt});
            }
            return stmt;
        }
        catch (Throwable ex) {
            DBUtil.close((Statement)stmt);
            throw new DBException(ex);
        }
    }

    public IDBPreparedStatement createObjectIDStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIDs});
        }
        return accessor.getDBConnection().prepareStatement(this.sqlSelectAllObjectIDs, IDBPreparedStatement.ReuseProbability.HIGH);
    }

    @Override
    protected final void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, revision.getID());
                stmt.setInt(column++, revision.getVersion());
                stmt.setLong(column++, revision.getTimeStamp());
                stmt.setLong(column++, revision.getRevised());
                idHandler.setCDOID((PreparedStatement)stmt, column++, revision.getResourceID());
                idHandler.setCDOID((PreparedStatement)stmt, column++, (CDOID)revision.getContainerID());
                stmt.setInt(column++, revision.getContainingFeatureID());
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        if (revision.getValue(feature) == null) {
                            stmt.setBoolean(isSetCol++, false);
                            mapping.setDefaultValue((PreparedStatement)stmt, column++);
                            continue;
                        }
                        stmt.setBoolean(isSetCol++, true);
                    }
                    mapping.setValueFromRevision((PreparedStatement)stmt, column++, revision);
                }
                Map<EStructuralFeature, IDBField> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    for (EStructuralFeature feature : listSizeFields.keySet()) {
                        CDOList list = revision.getListOrNull(feature);
                        int size = list == null ? -1 : list.size();
                        stmt.setInt(column++, size);
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    protected void detachAttributes(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor mon) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, -version);
                stmt.setLong(column++, timeStamp);
                stmt.setLong(column++, 0L);
                idHandler.setCDOID((PreparedStatement)stmt, column++, CDOID.NULL);
                idHandler.setCDOID((PreparedStatement)stmt, column++, CDOID.NULL);
                stmt.setInt(column++, 0);
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        stmt.setBoolean(isSetCol++, false);
                    }
                    mapping.setDefaultValue((PreparedStatement)stmt, column++);
                }
                Map<EStructuralFeature, IDBField> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    int i = 0;
                    while (i < listSizeFields.size()) {
                        stmt.setInt(column++, 0);
                        ++i;
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    protected void rawDeleteAttributes(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version, OMMonitor fork) {
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlRawDeleteAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                this.getMappingStrategy().getStore().getIDHandler().setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, version);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    protected void reviseOldRevision(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, long revised) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlReviseAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setLong(1, revised);
                idHandler.setCDOID((PreparedStatement)stmt, 2, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void writeRevisionDelta(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                async = monitor.forkAsync();
                FeatureDeltaWriter writer = new FeatureDeltaWriter();
                writer.process(accessor, delta, created);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected String getListXRefsWhere(IStoreAccessor.QueryXRefsContext context) {
        if (context.getBranch().getID() != 0) {
            throw new IllegalArgumentException("Non-audit mode does not support branch specification");
        }
        StringBuilder builder = new StringBuilder();
        long timeStamp = context.getTimeStamp();
        if (timeStamp == 0L) {
            builder.append(this.revisedField);
            builder.append("=0");
        } else {
            builder.append(this.createdField);
            builder.append("<=");
            builder.append(timeStamp);
            builder.append(" AND (");
            builder.append(this.revisedField);
            builder.append("=0 OR ");
            builder.append(this.revisedField);
            builder.append(">=");
            builder.append(timeStamp);
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public void readUnitRevisions(IDBStoreAccessor accessor, CDOBranchPoint branchPoint, CDOID rootID, CDORevisionHandler revisionHandler) throws SQLException {
        DBStore store = (DBStore)this.getMappingStrategy().getStore();
        InternalRepository repository = store.getRepository();
        CDOBranchPoint head = repository.getBranchManager().getMainBranch().getHead();
        EClass eClass = this.getEClass();
        long timeStamp = branchPoint.getTimeStamp();
        IIDHandler idHandler = store.getIDHandler();
        IDBPreparedStatement stmt = null;
        int jdbcFetchSize = store.getJDBCFetchSize();
        int oldFetchSize = -1;
        long start1 = TRACER_UNITS.isEnabled() ? System.currentTimeMillis() : 0L;
        try {
            stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectUnitByTime, IDBPreparedStatement.ReuseProbability.MEDIUM);
            idHandler.setCDOID((PreparedStatement)stmt, 1, rootID);
            stmt.setLong(2, timeStamp);
            stmt.setLong(3, timeStamp);
            AsnychronousListFiller listFiller = new AsnychronousListFiller(accessor, timeStamp, rootID, revisionHandler);
            ConcurrencyUtil.execute((Object)repository, (Runnable)listFiller);
            oldFetchSize = stmt.getFetchSize();
            stmt.setFetchSize(jdbcFetchSize);
            IDBResultSet resultSet = stmt.executeQuery();
            while (true) {
                InternalCDORevision revision = store.createRevision(eClass, null);
                revision.setBranchPoint(head);
                if (!this.readValuesFromResultSet((ResultSet)resultSet, idHandler, revision, true)) break;
                listFiller.schedule(revision);
            }
            long start2 = start1 != 0L ? System.currentTimeMillis() : start1;
            listFiller.await();
            if (start1 != 0L) {
                TRACER_UNITS.format("Read {0} revisions of unit {1}: {2} millis + {3} millis", new Object[]{eClass.getName(), rootID, start2 - start1, System.currentTimeMillis() - start2});
            }
        }
        finally {
            if (oldFetchSize != -1) {
                stmt.setFetchSize(oldFetchSize);
            }
            DBUtil.close((Statement)stmt);
        }
    }

    private class AsnychronousListFiller
    implements Runnable {
        private final BlockingQueue<InternalCDORevision> queue = new LinkedBlockingQueue<InternalCDORevision>();
        private final CountDownLatch latch = new CountDownLatch(1);
        private final IDBStoreAccessor accessor;
        private final long timeStamp;
        private final CDOID rootID;
        private final DBStore store;
        private final IIDHandler idHandler;
        private final IListMappingUnitSupport[] listMappings;
        private final ResultSet[] resultSets;
        private final CDORevisionHandler revisionHandler;
        private Throwable exception;

        public AsnychronousListFiller(IDBStoreAccessor accessor, long timeStamp, CDOID rootID, CDORevisionHandler revisionHandler) {
            this.accessor = accessor;
            this.timeStamp = timeStamp;
            this.rootID = rootID;
            this.revisionHandler = revisionHandler;
            this.store = (DBStore)accessor.getStore();
            this.idHandler = this.store.getIDHandler();
            List<IListMapping> tmp = HorizontalAuditClassMapping.this.getListMappings();
            int size = tmp.size();
            this.listMappings = new IListMappingUnitSupport[size];
            this.resultSets = new ResultSet[size];
            int i = 0;
            for (IListMapping listMapping : tmp) {
                this.listMappings[i++] = (IListMappingUnitSupport)listMapping;
            }
        }

        public void schedule(InternalCDORevision revision) {
            this.queue.offer(revision);
        }

        /*
         * Unable to fully structure code
         */
        public void await() throws SQLException {
            this.schedule((InternalCDORevision)new StubCDORevision(HorizontalAuditClassMapping.this.getEClass()));
            try {
                try {
                    this.latch.await();
                }
                catch (InterruptedException ex) {
                    throw new TimeoutRuntimeException();
                }
            }
            finally {
                var6_4 = this.resultSets;
                var5_6 = this.resultSets.length;
                var4_8 = 0;
                ** while (var4_8 < var5_6)
            }
lbl-1000:
            // 1 sources

            {
                resultSet = var6_4[var4_8];
                if (resultSet != null) {
                    statement = resultSet.getStatement();
                    DBUtil.close((Statement)statement);
                }
                ++var4_8;
                continue;
            }
lbl20:
            // 1 sources

            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            if (this.exception instanceof SQLException) {
                throw (SQLException)this.exception;
            }
            if (this.exception instanceof Exception) {
                throw WrappedException.wrap((Exception)((Exception)this.exception));
            }
        }

        @Override
        public void run() {
            StoreThreadLocal.setAccessor((IStoreAccessor)this.accessor);
            try {
                while (this.store.isActive()) {
                    InternalCDORevision revision = this.queue.poll(1L, TimeUnit.SECONDS);
                    if (revision == null) continue;
                    if (revision instanceof StubCDORevision) {
                        return;
                    }
                    try {
                        this.readUnitEntries(revision);
                        continue;
                    }
                    catch (Throwable ex) {
                        this.exception = ex;
                    }
                    break;
                }
            }
            finally {
                this.latch.countDown();
                StoreThreadLocal.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readUnitEntries(InternalCDORevision revision) throws SQLException {
            CDOID id = revision.getID();
            int i = 0;
            while (i < this.listMappings.length) {
                int size;
                IListMappingUnitSupport listMapping = this.listMappings[i];
                EStructuralFeature feature = listMapping.getFeature();
                CDOList list = revision.getListOrNull(feature);
                if (list != null && (size = list.size()) != 0) {
                    if (this.resultSets[i] == null) {
                        this.resultSets[i] = listMapping.queryUnitEntries(this.accessor, this.idHandler, this.timeStamp, this.rootID);
                    }
                    listMapping.readUnitEntries(this.resultSets[i], this.idHandler, id, (MoveableList<Object>)list);
                }
                ++i;
            }
            CDORevisionHandler cDORevisionHandler = this.revisionHandler;
            synchronized (cDORevisionHandler) {
                this.revisionHandler.handleRevision((CDORevision)revision);
            }
        }
    }

    private final class FeatureDeltaWriter
    extends AbstractHorizontalClassMapping.AbstractFeatureDeltaWriter {
        private int oldVersion;
        private InternalCDORevision newRevision;
        private int branchId;

        private FeatureDeltaWriter() {
            super(HorizontalAuditClassMapping.this);
        }

        @Override
        protected void doProcess(InternalCDORevisionDelta delta) {
            this.branchId = delta.getBranch().getID();
            this.oldVersion = delta.getVersion();
            if (TRACER.isEnabled()) {
                TRACER.format("FeatureDeltaWriter: old version: {0}, new version: {1}", new Object[]{this.oldVersion, this.oldVersion + 1});
            }
            InternalCDORevision originalRevision = (InternalCDORevision)this.accessor.getStore().getRepository().getRevisionManager().getRevisionByVersion(this.id, (CDOBranchVersion)delta, 0, true);
            this.newRevision = originalRevision.copy();
            this.newRevision.setVersion(this.oldVersion + 1);
            this.newRevision.setBranchPoint(delta.getBranch().getPoint(this.created));
            delta.accept((CDOFeatureDeltaVisitor)this);
            long revised = this.newRevision.getTimeStamp() - 1L;
            HorizontalAuditClassMapping.this.reviseOldRevision(this.accessor, this.id, delta.getBranch(), revised);
            HorizontalAuditClassMapping.this.writeValues(this.accessor, this.newRevision);
        }

        public void visit(CDOSetFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
        }

        public void visit(CDOListFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
            IListMappingDeltaSupport listMapping = (IListMappingDeltaSupport)((Object)HorizontalAuditClassMapping.this.getListMapping(delta.getFeature()));
            listMapping.processDelta(this.accessor, this.id, this.branchId, this.oldVersion, this.oldVersion + 1, this.created, delta);
        }

        public void visit(CDOContainerFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
        }
    }
}

