/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.UserLibrary;
import org.eclipse.dltk.internal.core.UserLibraryManager;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPageExtension2;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPUserLibraryElement;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.preferences.UserLibraryPreferencePage;
import org.eclipse.dltk.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UserLibraryWizardPage
extends NewElementWizardPage
implements IBuildpathContainerPage,
IBuildpathContainerPageExtension,
IBuildpathContainerPageExtension2 {
    private CheckedListDialogField fLibrarySelector;
    private BPUserLibraryElement fEditResult;
    private Set fUsedPaths;
    private boolean fIsEditMode;
    private IScriptProject fProject;
    private boolean fIsExported;
    private IDLTKLanguageToolkit languageToolkit;

    public UserLibraryWizardPage() {
        super("UserLibraryWizardPage");
        this.setTitle(NewWizardMessages.UserLibraryWizardPage_title);
        this.setImageDescriptor(DLTKPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.updateDescription(null);
        this.fUsedPaths = new HashSet();
        this.fProject = UserLibraryWizardPage.createPlaceholderProject();
        LibraryListAdapter adapter = new LibraryListAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.UserLibraryWizardPage_list_config_button};
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        this.fLibrarySelector = new CheckedListDialogField(adapter, buttonLabels, (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new BPListLabelProvider(), (ILabelDecorator)decoratorManager));
        this.fLibrarySelector.setDialogFieldListener(adapter);
        this.fLibrarySelector.setLabelText(NewWizardMessages.UserLibraryWizardPage_list_label);
        this.fEditResult = null;
        this.updateStatus(this.validateSetting(Collections.EMPTY_LIST));
    }

    private static IScriptProject createPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return DLTKCore.create((IProject)project);
    }

    private void updateDescription(IBuildpathEntry containerEntry) {
        if (containerEntry == null || containerEntry.getPath().segmentCount() != 2) {
            this.setDescription(NewWizardMessages.UserLibraryWizardPage_description_new);
        } else {
            this.setDescription(NewWizardMessages.UserLibraryWizardPage_description_edit);
        }
    }

    private List updateLibraryList() {
        HashSet<String> oldNames = new HashSet<String>();
        HashSet<String> oldCheckedNames = new HashSet<String>();
        List oldElements = this.fLibrarySelector.getElements();
        int i = 0;
        while (i < oldElements.size()) {
            BPUserLibraryElement curr = (BPUserLibraryElement)oldElements.get(i);
            oldNames.add(curr.getName());
            if (this.fLibrarySelector.isChecked(curr)) {
                oldCheckedNames.add(curr.getName());
            }
            ++i;
        }
        ArrayList<BPUserLibraryElement> entriesToCheck = new ArrayList<BPUserLibraryElement>();
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.fProject);
        if (toolkit == null) {
            toolkit = this.languageToolkit;
        }
        String[] names = DLTKCore.getUserLibraryNames((IDLTKLanguageToolkit)toolkit);
        Arrays.sort(names, Collator.getInstance());
        ArrayList<BPUserLibraryElement> elements = new ArrayList<BPUserLibraryElement>(names.length);
        int i2 = 0;
        while (i2 < names.length) {
            String curr = names[i2];
            UserLibrary lib = ModelManager.getUserLibraryManager().getUserLibrary(curr, toolkit);
            if (lib != null) {
                IPath path = new Path("org.eclipse.dltk.USER_LIBRARY").append(UserLibraryManager.makeLibraryName((String)curr, (IDLTKLanguageToolkit)toolkit));
                try {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)path, (IScriptProject)this.fProject);
                    BPUserLibraryElement elem = new BPUserLibraryElement(curr, container, this.fProject, (Map<String, String>)lib.getAttributes());
                    elements.add(elem);
                    if (!oldCheckedNames.isEmpty()) {
                        if (oldCheckedNames.contains(curr)) {
                            entriesToCheck.add(elem);
                        }
                    } else if (!oldNames.contains(curr)) {
                        entriesToCheck.add(elem);
                    }
                }
                catch (ModelException e) {
                    DLTKUIPlugin.log(e);
                }
            }
            ++i2;
        }
        this.fLibrarySelector.setElements(elements);
        return entriesToCheck;
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fLibrarySelector) {
            List list = this.fLibrarySelector.getCheckedElements();
            if (this.fIsEditMode) {
                if (list.size() > 1) {
                    if (this.fEditResult != null && list.remove(this.fEditResult)) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(this.fEditResult, false);
                    }
                    this.fEditResult = (BPUserLibraryElement)list.get(0);
                    int i = 1;
                    while (i < list.size()) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(list.get(i), false);
                        ++i;
                    }
                } else if (list.size() == 1) {
                    this.fEditResult = (BPUserLibraryElement)list.get(0);
                }
            }
            this.updateStatus(this.validateSetting(list));
        }
    }

    private IStatus validateSetting(List selected) {
        int nSelected = selected.size();
        if (nSelected == 0) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectentry);
        }
        if (this.fIsEditMode && nSelected > 1) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectonlyone);
        }
        int i = 0;
        while (i < selected.size()) {
            BPUserLibraryElement curr = (BPUserLibraryElement)selected.get(i);
            if (this.fUsedPaths.contains(curr.getPath())) {
                return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_alreadyoncp);
            }
            ++i;
        }
        return new StatusInfo();
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            HashMap<String, String> data = new HashMap<String, String>(3);
            if (this.fEditResult != null) {
                data.put("select_library", this.fEditResult.getName());
            }
            String id = UserLibraryPreferencePage.getPreferencePageId(this.languageToolkit);
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, data).open();
            List newEntries = this.updateLibraryList();
            if (newEntries.size() > 0) {
                if (this.fIsEditMode) {
                    this.fLibrarySelector.setChecked(newEntries.get(0), true);
                } else {
                    this.fLibrarySelector.setCheckedElements(newEntries);
                }
            }
        } else {
            this.fLibrarySelector.setCheckedElements(this.fLibrarySelector.getSelectedElements());
        }
    }

    private void doDoubleClicked(ListDialogField field) {
        Object elem;
        boolean state;
        List list;
        if (!(field != this.fLibrarySelector || (list = this.fLibrarySelector.getSelectedElements()).size() != 1 || (state = this.fLibrarySelector.isChecked(elem = list.get(0))) && this.fIsEditMode)) {
            this.fLibrarySelector.setChecked(elem, !state);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrarySelector}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrarySelector.getListControl(null));
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    @Override
    public boolean finish() {
        return true;
    }

    @Override
    public IBuildpathEntry getSelection() {
        if (this.fEditResult != null) {
            return DLTKCore.newContainerEntry((IPath)this.fEditResult.getPath(), (boolean)this.fIsExported);
        }
        return null;
    }

    @Override
    public IBuildpathEntry[] getNewContainers() {
        List selected = this.fLibrarySelector.getCheckedElements();
        IBuildpathEntry[] res = new IBuildpathEntry[selected.size()];
        int i = 0;
        while (i < res.length) {
            BPUserLibraryElement curr = (BPUserLibraryElement)selected.get(i);
            res[i] = DLTKCore.newContainerEntry((IPath)curr.getPath(), (boolean)this.fIsExported);
            ++i;
        }
        return res;
    }

    @Override
    public void setSelection(IBuildpathEntry containerEntry) {
        this.fIsExported = containerEntry != null && containerEntry.isExported();
        this.updateDescription(containerEntry);
        boolean bl = this.fIsEditMode = containerEntry != null;
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
        }
        String selected = null;
        if (containerEntry != null && containerEntry.getPath().segmentCount() == 2) {
            selected = containerEntry.getPath().segment(1);
        }
        this.updateLibraryList();
        if (selected != null) {
            List elements = this.fLibrarySelector.getElements();
            int i = 0;
            while (i < elements.size()) {
                BPUserLibraryElement curr = (BPUserLibraryElement)elements.get(i);
                if (curr.getName().equals(selected)) {
                    this.fLibrarySelector.setChecked(curr, true);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        this.languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        int i = 0;
        while (i < currentEntries.length) {
            IBuildpathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    private class LibraryListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        @Override
        public void dialogFieldChanged(DialogField field) {
            UserLibraryWizardPage.this.doDialogFieldChanged(field);
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            UserLibraryWizardPage.this.doButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            UserLibraryWizardPage.this.doDoubleClicked(field);
        }
    }
}

