/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeatureData;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.feature.FeatureInfo;
import org.eclipse.pde.internal.core.feature.FeatureInstallHandler;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.feature.FeatureURL;
import org.eclipse.pde.internal.core.feature.VersionableObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Feature
extends VersionableObject
implements IFeature {
    private static final long serialVersionUID = 1L;
    static final String INDENT = "   ";
    private String fProviderName;
    private IFeatureURL fUrl;
    private final IFeatureInfo[] fInfos = new IFeatureInfo[3];
    private final Vector<IFeatureData> fData = new Vector();
    private final Vector<IFeatureChild> fChildren = new Vector();
    private final Vector<IFeaturePlugin> fPlugins = new Vector();
    private final Vector<IFeatureImport> fImports = new Vector();
    private String fOs;
    private String fWs;
    private String fNl;
    private String fArch;
    private String fImageName;
    private IFeatureInstallHandler fHandler;
    private boolean fPrimary;
    private boolean fExclusive;
    private String fColocationAffinity;
    private String fApplication;
    private String fPlugin;
    private boolean fValid;
    private String fCopyright;
    private String fLicenseFeatureID;
    private String fLicenseFeatureVersion;
    private boolean fIncludeSources;

    @Override
    public void addPlugins(IFeaturePlugin[] newPlugins) throws CoreException {
        this.ensureModelEditable();
        IFeaturePlugin[] iFeaturePluginArray = newPlugins;
        int n = newPlugins.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin plugin = iFeaturePluginArray[n2];
            this.fPlugins.add(plugin);
            ((FeaturePlugin)plugin).setInTheModel(true);
            ++n2;
        }
        this.fireStructureChanged(newPlugins, 1);
    }

    @Override
    public void addData(IFeatureData[] newData) throws CoreException {
        this.ensureModelEditable();
        IFeatureData[] iFeatureDataArray = newData;
        int n = newData.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureData data = iFeatureDataArray[n2];
            this.fData.add(data);
            ((FeatureData)data).setInTheModel(true);
            ++n2;
        }
        this.fireStructureChanged(newData, 1);
    }

    @Override
    public void addIncludedFeatures(IFeatureChild[] features) throws CoreException {
        this.ensureModelEditable();
        IFeatureChild[] iFeatureChildArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild child = iFeatureChildArray[n2];
            this.fChildren.add(child);
            ((FeatureChild)child).setInTheModel(true);
            ++n2;
        }
        this.fireStructureChanged(features, 1);
    }

    @Override
    public void addImports(IFeatureImport[] iimports) throws CoreException {
        this.ensureModelEditable();
        IFeatureImport[] iFeatureImportArray = iimports;
        int n = iimports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport iimport = iFeatureImportArray[n2];
            this.fImports.add(iimport);
            ((FeatureImport)iimport).setInTheModel(true);
            ++n2;
        }
        this.fireStructureChanged(iimports, 1);
    }

    @Override
    public IFeaturePlugin[] getPlugins() {
        Object[] result = new IFeaturePlugin[this.fPlugins.size()];
        this.fPlugins.copyInto(result);
        return result;
    }

    @Override
    public IFeatureData[] getData() {
        Object[] result = new IFeatureData[this.fData.size()];
        this.fData.copyInto(result);
        return result;
    }

    @Override
    public IFeatureChild[] getIncludedFeatures() {
        Object[] result = new IFeatureChild[this.fChildren.size()];
        this.fChildren.copyInto(result);
        return result;
    }

    @Override
    public IFeatureImport[] getImports() {
        Object[] result = new IFeatureImport[this.fImports.size()];
        this.fImports.copyInto(result);
        return result;
    }

    @Override
    public String getProviderName() {
        return this.fProviderName;
    }

    @Override
    public void setLicenseFeatureID(String featureID) {
        this.fLicenseFeatureID = featureID;
    }

    @Override
    public String getLicenseFeatureID() {
        if (this.fLicenseFeatureID == null) {
            this.fLicenseFeatureID = "";
        }
        return this.fLicenseFeatureID;
    }

    @Override
    public void setLicenseFeatureVersion(String version) {
        this.fLicenseFeatureVersion = version;
    }

    @Override
    public String getLicenseFeatureVersion() {
        if (this.fLicenseFeatureVersion == null) {
            this.fLicenseFeatureVersion = "";
        }
        return this.fLicenseFeatureVersion;
    }

    @Override
    public String getPlugin() {
        return this.fPlugin;
    }

    @Override
    public IPluginModelBase getReferencedModel(IFeaturePlugin reference) {
        IPluginModelBase model = PluginRegistry.findModel(reference.getId());
        return model != null && model.isEnabled() ? model : null;
    }

    @Override
    public IFeatureURL getURL() {
        return this.fUrl;
    }

    @Override
    public IFeatureInstallHandler getInstallHandler() {
        return this.fHandler;
    }

    @Override
    public IFeatureInfo getFeatureInfo(int infoType) {
        if (infoType < 0 || infoType > this.fInfos.length - 1) {
            return null;
        }
        return this.fInfos[infoType];
    }

    @Override
    public boolean isPrimary() {
        return this.fPrimary;
    }

    @Override
    public boolean isExclusive() {
        return this.fExclusive;
    }

    @Override
    protected void parse(Node node) {
        super.parse(node);
        this.fProviderName = this.getNodeAttribute(node, "provider-name");
        this.fLicenseFeatureID = this.getNodeAttribute(node, "license-feature");
        this.fLicenseFeatureVersion = this.getNodeAttribute(node, "license-feature-version");
        this.fPlugin = this.getNodeAttribute(node, "plugin");
        this.fOs = this.getNodeAttribute(node, "os");
        this.fWs = this.getNodeAttribute(node, "ws");
        this.fNl = this.getNodeAttribute(node, "nl");
        this.fArch = this.getNodeAttribute(node, "arch");
        this.fImageName = this.getNodeAttribute(node, "image");
        this.fColocationAffinity = this.getNodeAttribute(node, "colocation-affinity");
        this.fApplication = this.getNodeAttribute(node, "application");
        this.fPrimary = this.getBooleanAttribute(node, "primary");
        this.fExclusive = this.getBooleanAttribute(node, "exclusive");
        this.fIncludeSources = this.getBooleanAttribute(node, "include-sources");
        NodeList children = node.getChildNodes();
        this.fValid = true;
        int i = 0;
        while (i < children.getLength()) {
            block32: {
                String tag;
                Node child = children.item(i);
                if (child.getNodeType() != 1) break block32;
                switch (tag = child.getNodeName().toLowerCase(Locale.ENGLISH)) {
                    case "description": {
                        IFeatureInfo info = this.getModel().getFactory().createInfo(0);
                        ((FeatureInfo)info).setInTheModel(true);
                        ((FeatureInfo)info).parse(child);
                        this.fInfos[0] = info;
                        break;
                    }
                    case "license": {
                        IFeatureInfo info = this.getModel().getFactory().createInfo(2);
                        ((FeatureInfo)info).setInTheModel(true);
                        ((FeatureInfo)info).parse(child);
                        this.fInfos[2] = info;
                        break;
                    }
                    case "copyright": {
                        IFeatureInfo info = this.getModel().getFactory().createInfo(1);
                        ((FeatureInfo)info).setInTheModel(true);
                        ((FeatureInfo)info).parse(child);
                        this.fInfos[1] = info;
                        break;
                    }
                    case "url": {
                        if (this.fUrl != null) break;
                        this.fUrl = this.getModel().getFactory().createURL();
                        ((FeatureURL)this.fUrl).setInTheModel(true);
                        ((FeatureURL)this.fUrl).parse(child);
                        break;
                    }
                    case "requires": {
                        this.parseRequires(child);
                        break;
                    }
                    case "install-handler": {
                        IFeatureInstallHandler handler = this.getModel().getFactory().createInstallHandler();
                        ((FeatureInstallHandler)handler).parse(child);
                        ((FeatureInstallHandler)handler).setInTheModel(true);
                        this.fHandler = handler;
                        break;
                    }
                    case "plugin": {
                        IFeaturePlugin plugin = this.getModel().getFactory().createPlugin();
                        ((FeaturePlugin)plugin).parse(child);
                        ((FeaturePlugin)plugin).setInTheModel(true);
                        this.fPlugins.add(plugin);
                        break;
                    }
                    case "data": {
                        IFeatureData newData = this.getModel().getFactory().createData();
                        ((FeatureData)newData).parse(child);
                        ((FeatureData)newData).setInTheModel(true);
                        this.fData.add(newData);
                        break;
                    }
                    case "includes": {
                        IFeatureChild newChild = this.getModel().getFactory().createChild();
                        ((FeatureChild)newChild).parse(child);
                        ((FeatureChild)newChild).setInTheModel(true);
                        this.fChildren.add(newChild);
                        break;
                    }
                }
            }
            ++i;
        }
        this.fValid = this.hasRequiredAttributes();
    }

    private void parseRequires(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("import")) {
                IFeatureImport iimport = this.getModel().getFactory().createImport();
                ((FeatureImport)iimport).parse(child);
                ((FeatureImport)iimport).setInTheModel(true);
                this.fImports.add(iimport);
            }
            ++i;
        }
    }

    @Override
    public void removePlugins(IFeaturePlugin[] removed) throws CoreException {
        this.ensureModelEditable();
        IFeaturePlugin[] iFeaturePluginArray = removed;
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin element = iFeaturePluginArray[n2];
            this.fPlugins.remove(element);
            ((FeaturePlugin)element).setInTheModel(false);
            ++n2;
        }
        this.fireStructureChanged(removed, 2);
    }

    @Override
    public void removeData(IFeatureData[] removed) throws CoreException {
        this.ensureModelEditable();
        IFeatureData[] iFeatureDataArray = removed;
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureData element = iFeatureDataArray[n2];
            this.fData.remove(element);
            ((FeatureData)element).setInTheModel(false);
            ++n2;
        }
        this.fireStructureChanged(removed, 2);
    }

    @Override
    public void removeIncludedFeatures(IFeatureChild[] features) throws CoreException {
        this.ensureModelEditable();
        IFeatureChild[] iFeatureChildArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild feature = iFeatureChildArray[n2];
            this.fChildren.remove(feature);
            ((FeatureChild)feature).setInTheModel(false);
            ++n2;
        }
        this.fireStructureChanged(features, 2);
    }

    @Override
    public void removeImports(IFeatureImport[] iimports) throws CoreException {
        this.ensureModelEditable();
        IFeatureImport[] iFeatureImportArray = iimports;
        int n = iimports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport iimport = iFeatureImportArray[n2];
            this.fImports.remove(iimport);
            ((FeatureImport)iimport).setInTheModel(false);
            ++n2;
        }
        this.fireStructureChanged(iimports, 2);
    }

    @Override
    public String getOS() {
        return this.fOs;
    }

    @Override
    public String getWS() {
        return this.fWs;
    }

    @Override
    public String getNL() {
        return this.fNl;
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public String getColocationAffinity() {
        return this.fColocationAffinity;
    }

    @Override
    public String getApplication() {
        return this.fApplication;
    }

    @Override
    public boolean isIncludingSources() {
        return this.fIncludeSources;
    }

    @Override
    public void setOS(String os) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fOs;
        this.fOs = os;
        this.firePropertyChanged("os", oldValue, os);
    }

    @Override
    public void setWS(String ws) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fWs;
        this.fWs = ws;
        this.firePropertyChanged("ws", oldValue, ws);
    }

    @Override
    public void setNL(String nl) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fNl;
        this.fNl = nl;
        this.firePropertyChanged("nl", oldValue, nl);
    }

    @Override
    public void setArch(String arch) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fArch;
        this.fArch = arch;
        this.firePropertyChanged("arch", oldValue, arch);
    }

    @Override
    public void setPrimary(boolean newValue) throws CoreException {
        if (this.fPrimary == newValue) {
            return;
        }
        this.ensureModelEditable();
        Boolean oldValue = this.fPrimary ? Boolean.TRUE : Boolean.FALSE;
        this.fPrimary = newValue;
        this.firePropertyChanged("primary", oldValue, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setExclusive(boolean newValue) throws CoreException {
        if (this.fExclusive == newValue) {
            return;
        }
        this.ensureModelEditable();
        Boolean oldValue = this.fExclusive ? Boolean.TRUE : Boolean.FALSE;
        this.fExclusive = newValue;
        this.firePropertyChanged("exclusive", oldValue, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setColocationAffinity(String newValue) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fColocationAffinity;
        this.fColocationAffinity = newValue;
        this.firePropertyChanged("colocation-affinity", oldValue, newValue);
    }

    @Override
    public void setApplication(String newValue) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fApplication;
        this.fApplication = newValue;
        this.firePropertyChanged("application", oldValue, newValue);
    }

    @Override
    public void setIncludingSources(boolean includesSources) {
        Boolean oldValue = this.fIncludeSources;
        this.fIncludeSources = includesSources;
        this.firePropertyChanged(this, "include-sources", oldValue, includesSources);
    }

    @Override
    public void setProviderName(String providerName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fProviderName;
        this.fProviderName = providerName;
        this.firePropertyChanged("provider", oldValue, providerName);
    }

    @Override
    public void setPlugin(String plugin) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fPlugin;
        this.fPlugin = plugin;
        this.firePropertyChanged("plugin", oldValue, plugin);
    }

    @Override
    public void setURL(IFeatureURL url) throws CoreException {
        this.ensureModelEditable();
        IFeatureURL oldValue = this.fUrl;
        if (this.fUrl != null) {
            ((FeatureURL)this.fUrl).setInTheModel(false);
        }
        this.fUrl = url;
        this.firePropertyChanged("url", oldValue, url);
    }

    @Override
    public void setInstallHandler(IFeatureInstallHandler handler) throws CoreException {
        this.ensureModelEditable();
        IFeatureInstallHandler oldValue = this.fHandler;
        if (this.fHandler != null) {
            ((FeatureInstallHandler)this.fHandler).setInTheModel(false);
        }
        this.fHandler = handler;
        this.firePropertyChanged("installHandler", oldValue, handler);
    }

    @Override
    public void setFeatureInfo(IFeatureInfo info, int index) throws CoreException {
        String property;
        this.ensureModelEditable();
        IFeatureInfo oldValue = this.fInfos[index];
        if (oldValue != null) {
            ((FeatureInfo)oldValue).setInTheModel(true);
        }
        this.fInfos[index] = info;
        switch (index) {
            case 0: {
                property = "description";
                break;
            }
            case 2: {
                property = "license";
                break;
            }
            case 1: {
                property = "copyright";
                break;
            }
            default: {
                return;
            }
        }
        this.firePropertyChanged(property, oldValue, info);
    }

    @Override
    public void setImageName(String imageName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fImageName;
        this.fImageName = imageName;
        this.firePropertyChanged("image", oldValue, imageName);
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        switch (name) {
            case "os": {
                this.setOS((String)newValue);
                break;
            }
            case "ws": {
                this.setWS((String)newValue);
                break;
            }
            case "nl": {
                this.setNL((String)newValue);
                break;
            }
            case "arch": {
                this.setArch((String)newValue);
                break;
            }
            case "colocation-affinity": {
                this.setColocationAffinity((String)newValue);
                break;
            }
            case "application": {
                this.setApplication((String)newValue);
                break;
            }
            case "primary": {
                this.setPrimary(newValue != null ? (Boolean)newValue : false);
                break;
            }
            case "exclusive": {
                this.setExclusive(newValue != null ? (Boolean)newValue : false);
                break;
            }
            case "provider": {
                this.setProviderName((String)newValue);
                break;
            }
            case "plugin": {
                this.setPlugin((String)newValue);
                break;
            }
            case "url": {
                this.setURL((IFeatureURL)newValue);
                break;
            }
            case "installHandler": {
                this.setInstallHandler((IFeatureInstallHandler)newValue);
                break;
            }
            case "description": {
                this.setFeatureInfo((IFeatureInfo)newValue, 0);
                break;
            }
            case "license": {
                this.setFeatureInfo((IFeatureInfo)newValue, 2);
                break;
            }
            case "copyright": {
                this.setFeatureInfo((IFeatureInfo)newValue, 1);
                break;
            }
            case "image": {
                this.setImageName((String)newValue);
                break;
            }
            case "include-sources": {
                this.setIncludingSources(newValue != null ? (Boolean)newValue : false);
                break;
            }
            default: {
                super.restoreProperty(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.fData.clear();
        this.fPlugins.clear();
        this.fIncludeSources = false;
        this.fImports.clear();
        this.fChildren.clear();
        this.fUrl = null;
        this.fProviderName = null;
        this.fPlugin = null;
        this.fOs = null;
        this.fWs = null;
        this.fNl = null;
        this.fArch = null;
        this.fInfos[0] = null;
        this.fInfos[1] = null;
        this.fInfos[2] = null;
        this.fPrimary = false;
        this.fExclusive = false;
        this.fColocationAffinity = null;
        this.fApplication = null;
        this.fValid = false;
    }

    @Override
    public boolean isValid() {
        return this.fValid;
    }

    protected boolean hasRequiredAttributes() {
        if (this.id == null) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        int i = 0;
        while (i < this.fChildren.size()) {
            IFeatureChild child = this.fChildren.elementAt(i);
            if (child.getId() == null || child.getVersion() == null) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fPlugins.size()) {
            IFeaturePlugin plugin = this.fPlugins.elementAt(i);
            if (plugin.getId() == null || plugin.getVersion() == null) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fData.size()) {
            IFeatureData entry = this.fData.elementAt(i);
            if (entry.getId() == null) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fImports.size()) {
            IFeatureImport iimport = this.fImports.elementAt(i);
            if (iimport.getId() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.fCopyright != null) {
            writer.println("<!--" + this.fCopyright + "-->");
        }
        writer.print(indent + "<feature");
        String indent2 = indent + INDENT;
        String indenta = indent + "      ";
        this.writeIfDefined(indenta, writer, "id", this.getId());
        this.writeIfDefined(indenta, writer, "label", this.getWritableString(this.getLabel()));
        this.writeIfDefined(indenta, writer, "version", this.getVersion());
        this.writeIfDefined(indenta, writer, "include-sources", this.isIncludingSources() ? String.valueOf(this.isIncludingSources()) : null);
        this.writeIfDefined(indenta, writer, "provider-name", this.getWritableString(this.fProviderName));
        this.writeIfDefined(indenta, writer, "plugin", this.getPlugin());
        this.writeIfDefined(indenta, writer, "os", this.fOs);
        this.writeIfDefined(indenta, writer, "ws", this.fWs);
        this.writeIfDefined(indenta, writer, "nl", this.fNl);
        this.writeIfDefined(indenta, writer, "arch", this.fArch);
        if (this.fImageName != null) {
            this.writeIfDefined(indenta, writer, "image", this.getWritableString(this.fImageName));
        }
        if (this.isPrimary()) {
            writer.println();
            writer.print(indenta + "primary=\"true\"");
        }
        if (this.getLicenseFeatureID().length() > 0) {
            writer.println();
            writer.print(indenta + "license-feature=\"" + this.getLicenseFeatureID() + "\"");
        }
        if (this.getLicenseFeatureVersion().length() > 0) {
            writer.println();
            writer.print(indenta + "license-feature-version=\"" + this.getLicenseFeatureVersion() + "\"");
        }
        if (this.isExclusive()) {
            writer.println();
            writer.print(indenta + "exclusive=\"true\"");
        }
        this.writeIfDefined(indenta, writer, "colocation-affinity", this.fColocationAffinity);
        this.writeIfDefined(indenta, writer, "application", this.fApplication);
        writer.println(">");
        if (this.fHandler != null) {
            this.fHandler.write(indent2, writer);
        }
        int i = 0;
        while (i < 3) {
            IFeatureInfo info = this.fInfos[i];
            if (info != null && !info.isEmpty()) {
                info.write(indent2, writer);
            }
            ++i;
        }
        if (this.fUrl != null) {
            this.fUrl.write(indent2, writer);
        }
        i = 0;
        while (i < this.fChildren.size()) {
            IFeatureChild child = this.fChildren.elementAt(i);
            writer.println();
            child.write(indent2, writer);
            ++i;
        }
        if (!this.fImports.isEmpty()) {
            writer.println();
            writer.println(indent2 + "<requires>");
            i = 0;
            while (i < this.fImports.size()) {
                IFeatureImport iimport = this.fImports.get(i);
                iimport.write(indenta, writer);
                ++i;
            }
            writer.println(indent2 + "</requires>");
        }
        i = 0;
        while (i < this.fPlugins.size()) {
            IFeaturePlugin plugin = this.fPlugins.elementAt(i);
            writer.println();
            plugin.write(indent2, writer);
            ++i;
        }
        i = 0;
        while (i < this.fData.size()) {
            IFeatureData entry = this.fData.elementAt(i);
            writer.println();
            entry.write(indent2, writer);
            ++i;
        }
        writer.println();
        writer.println(indent + "</feature>");
    }

    private void writeIfDefined(String indent, PrintWriter writer, String attName, String attValue) {
        if (attValue == null || attValue.trim().length() == 0) {
            return;
        }
        writer.println();
        writer.print(indent + attName + "=\"" + attValue + "\"");
    }

    @Override
    public String getImageName() {
        return this.fImageName;
    }

    public String getCopyright() {
        return this.fCopyright;
    }

    public void setCopyright(String copyright) {
        this.fCopyright = copyright;
    }

    @Override
    public void swap(IFeatureChild feature1, IFeatureChild feature2) {
        int index1 = this.fChildren.indexOf(feature1);
        int index2 = this.fChildren.indexOf(feature2);
        if (index1 == -1 || index2 == -1) {
            return;
        }
        this.fChildren.set(index2, feature1);
        this.fChildren.set(index1, feature2);
        this.fireStructureChanged(feature1, 3);
    }

    public String toString() {
        return this.getId() + " (" + this.getVersion() + ")";
    }
}

