/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.interop.internal.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.interop.ExecProcess;
import org.eclipse.rcptt.ecl.interop.ExecProcessResult;
import org.eclipse.rcptt.ecl.interop.InteropFactory;
import org.eclipse.rcptt.ecl.interop.internal.EclInteropPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ExecProcessService
implements ICommandService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        ExecProcess cmd = (ExecProcess)command;
        ArrayList<String> cmdArray = new ArrayList<String>();
        cmdArray.add(cmd.getCommand());
        for (String arg : cmd.getArgs()) {
            cmdArray.add(arg);
        }
        Runtime runtime = Runtime.getRuntime();
        ExecProcessResult result = InteropFactory.eINSTANCE.createExecProcessResult();
        try {
            Process process = runtime.exec(cmdArray.toArray(new String[cmdArray.size()]), null, null);
            if (cmd.getStdin() != null && cmd.getStdin().length() > 0) {
                BufferedWriter stdin = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                stdin.write(cmd.getStdin());
                ((Writer)stdin).flush();
            }
            process.getOutputStream().close();
            Executor executor = new Executor(process);
            executor.start();
            try {
                if (cmd.getTimeout() > 0) {
                    executor.join(cmd.getTimeout() * 1000);
                    executor.interrupt();
                    executor.join();
                } else {
                    executor.join();
                }
                if (executor.exitCode == null) {
                    Status status = EclInteropPlugin.error("Timeout period elapsed. Terminating.");
                    return status;
                }
                result.setExitCode(process.exitValue());
                result.setStdout(executor.stdout);
                result.setStderr(executor.stderr);
                if (!cmd.isIgnoreExitCode() && result.getExitCode() != 0) {
                    Status status = EclInteropPlugin.error("Execution failed, exit code: %s. stderr:\n %s", result.getExitCode(), result.getStderr());
                    return status;
                }
                if (!cmd.isIgnoreStderr() && result.getStderr().length() > 0) {
                    Status status = EclInteropPlugin.error("Execution failed, stderr:\n%s.", result.getStderr());
                    return status;
                }
            }
            catch (InterruptedException e) {
                executor.interrupt();
                Status status = EclInteropPlugin.error(e.getMessage());
                return status;
            }
            finally {
                process.destroy();
            }
        }
        catch (IOException e) {
            return EclInteropPlugin.error(e.getMessage());
        }
        context.getOutput().write((Object)result);
        return Status.OK_STATUS;
    }

    private static class Executor
    extends Thread {
        private final Process process;
        public Integer exitCode = null;
        public String stdout = "";
        public String stderr = "";

        private Executor(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            StringBuffer stdoutBuffer = new StringBuffer();
            ReaderReader stdoutReader = new ReaderReader(new BufferedReader(new InputStreamReader(this.process.getInputStream())), stdoutBuffer);
            StringBuffer stderrBuffer = new StringBuffer();
            ReaderReader stderrReader = new ReaderReader(new BufferedReader(new InputStreamReader(this.process.getErrorStream())), stderrBuffer);
            try {
                try {
                    stdoutReader.start();
                    stderrReader.start();
                    this.exitCode = this.process.waitFor();
                    stdoutReader.join();
                    stderrReader.join();
                }
                catch (InterruptedException ignore) {
                    stdoutReader.interrupt();
                    stderrReader.interrupt();
                    this.stdout = stdoutBuffer.toString();
                    this.stderr = stderrBuffer.toString();
                    return;
                }
            }
            finally {
                stdoutReader.interrupt();
                stderrReader.interrupt();
                this.stdout = stdoutBuffer.toString();
                this.stderr = stderrBuffer.toString();
            }
        }
    }

    private static class ReaderReader
    extends Thread {
        private Reader reader;
        private StringBuffer buffer;

        private ReaderReader(Reader reader, StringBuffer buffer) {
            this.reader = reader;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            char[] chars = new char[4096];
            while (!this.isInterrupted()) {
                try {
                    int read = this.reader.read(chars);
                    if (read == -1) break;
                    this.buffer.append(chars, 0, read);
                }
                catch (IOException e) {
                    break;
                }
            }
        }
    }
}

