/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;

public class NameGenerator {
    public static String createClassPropertyName(String name, String prefix) {
        StringBuilder buf = new StringBuilder(name.length() * 2);
        if (prefix != null) {
            buf.append(prefix);
        }
        char[] chars = name.toCharArray();
        char last = 'X';
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isLowerCase(last) && Character.isUpperCase(c)) {
                buf.append('.');
            }
            buf.append(Character.toLowerCase(c));
            last = c;
            ++i;
        }
        return buf.toString();
    }

    public static String createPropertyName(String name, String prefix, DSAnnotationVersion specVersion) {
        if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(specVersion)) {
            StringBuilder sb;
            if (prefix == null) {
                sb = new StringBuilder(name.length());
            } else {
                sb = new StringBuilder(name.length() + prefix.length());
                sb.append(prefix);
            }
            char[] chars = name.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c == '$') {
                    if (i < chars.length - 1) {
                        n = chars[i + 1];
                        if (n == '_') {
                            if (i < chars.length - 2 && chars[i + 2] == '$') {
                                i += 2;
                                sb.append('-');
                            }
                        } else if (n == '$') {
                            ++i;
                            sb.append('$');
                        }
                    }
                } else if (c == '_') {
                    n = chars[i + 1];
                    if (i < chars.length - 1 && n == '_') {
                        ++i;
                        sb.append('_');
                    } else {
                        sb.append('.');
                    }
                } else {
                    sb.append(chars[i]);
                }
                ++i;
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(name.length());
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '$') {
                if (i < chars.length - 1 && chars[i + 1] == '$') {
                    ++i;
                    sb.append('$');
                }
            } else if (c == '_') {
                if (i < chars.length - 1 && chars[i + 1] == '_') {
                    ++i;
                    sb.append('_');
                } else {
                    sb.append('.');
                }
            } else {
                sb.append(chars[i]);
            }
            ++i;
        }
        return sb.toString();
    }
}

