/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;

public class ZipFileExporter
implements IFileExporter {
    private final ZipOutputStream outputStream;
    private boolean useCompression = true;
    private final boolean resolveLinks;

    public ZipFileExporter(String filename, boolean compress, boolean resolveLinks) throws IOException {
        this.resolveLinks = resolveLinks;
        this.outputStream = new ZipOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
    }

    @Override
    public void finished() throws IOException {
        this.outputStream.close();
    }

    private void write(ZipEntry entry, IFile contents) throws IOException, CoreException {
        long localTimeStamp;
        int n;
        byte[] readBuffer = new byte[4096];
        if (!this.useCompression) {
            entry.setMethod(0);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream contentStream = contents.getContents(false);){
                int length = 0;
                CRC32 checksumCalculator = new CRC32();
                while ((n = contentStream.read(readBuffer)) > 0) {
                    checksumCalculator.update(readBuffer, 0, n);
                    length += n;
                }
                entry.setSize(length);
                entry.setCrc(checksumCalculator.getValue());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if ((localTimeStamp = contents.getLocalTimeStamp()) != -1L) {
            entry.setTime(localTimeStamp);
        }
        this.outputStream.putNextEntry(entry);
        Throwable throwable = null;
        Object var7_12 = null;
        try (InputStream contentStream = contents.getContents(false);){
            while ((n = contentStream.read(readBuffer)) > 0) {
                this.outputStream.write(readBuffer, 0, n);
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.outputStream.closeEntry();
    }

    @Override
    public void write(IContainer container, String destinationPath) throws IOException {
        if (!this.resolveLinks && container.isLinked(2)) {
            return;
        }
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.outputStream.putNextEntry(newEntry);
    }

    @Override
    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        if (!this.resolveLinks && resource.isLinked(2)) {
            return;
        }
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.write(newEntry, resource);
    }
}

