/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.BreakpointConditionEditor;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.DebugUIMessages;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.QVTOBreakpointPage;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.QVTODebugUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.SWTFactory;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOBreakpoint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class QVTOLineBreakpointPage
extends QVTOBreakpointPage {
    private Button fEnableConditionButton;
    private BreakpointConditionEditor fConditionEditor;
    private Button fConditionIsTrue;
    private Button fConditionHasChanged;
    private Label fSuspendWhenLabel;

    @Override
    protected void doStore() throws CoreException {
        QVTOBreakpoint breakpoint = this.getBreakpoint();
        super.doStore();
        if (this.fConditionEditor != null) {
            boolean enableCondition = this.fEnableConditionButton.getSelection();
            String condition = this.fConditionEditor.getCondition();
            boolean suspendOnTrue = this.fConditionIsTrue.getSelection();
            if (breakpoint.isConditionEnabled() != enableCondition) {
                breakpoint.setConditionEnabled(enableCondition);
            }
            if (!condition.equals(breakpoint.getCondition())) {
                breakpoint.setCondition(condition);
            }
            if (breakpoint.isConditionSuspendOnTrue() != suspendOnTrue) {
                breakpoint.setConditionSuspendOnTrue(suspendOnTrue);
            }
        }
    }

    @Override
    protected void createTypeSpecificLabels(Composite parent) {
        QVTOBreakpoint breakpoint = this.getBreakpoint();
        StringBuffer lineNumber = new StringBuffer(4);
        try {
            int lNumber = breakpoint.getLineNumber();
            if (lNumber > 0) {
                lineNumber.append(lNumber);
            }
        }
        catch (CoreException ce) {
            QVTODebugUIPlugin.log(ce);
        }
        if (lineNumber.length() > 0) {
            this.createLabel(parent, DebugUIMessages.QVTOLineBreakpointPage_LineNumber);
            Text text = SWTFactory.createText(parent, 8, 1, lineNumber.toString());
            text.setBackground(parent.getBackground());
        }
    }

    @Override
    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
        this.setTitle(DebugUIMessages.QVTOLineBreakpointPage_LineBreakpoint);
        QVTOBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint.supportsCondition()) {
            this.createConditionEditor(parent);
        }
    }

    private void createConditionEditor(Composite parent) throws CoreException {
        QVTOBreakpoint breakpoint = this.getBreakpoint();
        String label = DebugUIMessages.QVTOLineBreakpointPage_EnableCondition;
        Group conditionComposite = SWTFactory.createGroup(parent, "", 1, 1, 1808);
        this.fEnableConditionButton = this.createCheckButton((Composite)conditionComposite, label);
        this.fEnableConditionButton.setSelection(breakpoint.isConditionEnabled());
        this.fEnableConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QVTOLineBreakpointPage.this.setConditionEnabled(QVTOLineBreakpointPage.this.fEnableConditionButton.getSelection());
            }
        });
        this.fConditionEditor = new BreakpointConditionEditor((Composite)conditionComposite, this);
        this.fSuspendWhenLabel = this.createLabel((Composite)conditionComposite, DebugUIMessages.QVTOLineBreakpointPage_SuspendCondition);
        this.fConditionIsTrue = this.createRadioButton((Composite)conditionComposite, DebugUIMessages.QVTOLineBreakpointPage_ConditionTrue);
        this.fConditionHasChanged = this.createRadioButton((Composite)conditionComposite, DebugUIMessages.QVTOLineBreakpointPage_ConditionValueChange);
        if (breakpoint.isConditionSuspendOnTrue()) {
            this.fConditionIsTrue.setSelection(true);
        } else {
            this.fConditionHasChanged.setSelection(true);
        }
        this.setConditionEnabled(this.fEnableConditionButton.getSelection());
    }

    private void setConditionEnabled(boolean enabled) {
        this.fConditionEditor.setEnabled(enabled);
        this.fSuspendWhenLabel.setEnabled(enabled);
        this.fConditionIsTrue.setEnabled(enabled);
        this.fConditionHasChanged.setEnabled(enabled);
    }

    public int convertHeightInCharsToPixels(int chars) {
        return super.convertHeightInCharsToPixels(chars);
    }

    public int convertWidthInCharsToPixels(int chars) {
        return super.convertWidthInCharsToPixels(chars);
    }

    public void dispose() {
        if (this.fConditionEditor != null) {
            this.fConditionEditor.dispose();
        }
        super.dispose();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }
}

