/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.GenericsResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.ocl.AbstractTypeChecker;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.TemplateParameterType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeCheckerImpl
extends AbstractTypeChecker<EClassifier, EOperation, EStructuralFeature, EParameter> {
    private final GenericsResolver fGenericResolver;
    private final OCLStandardLibrary<EClassifier> fOCLStdlib;

    TypeCheckerImpl(QVTOEnvironment env) {
        super((Environment)env);
        this.fGenericResolver = new GenericsResolver(env);
        this.fOCLStdlib = this.getEnvironment().getOCLStandardLibrary();
    }

    protected QVTOEnvironment getEnvironment() {
        return (QVTOEnvironment)super.getEnvironment();
    }

    public EOperation findMostSpecificOperationMatching(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        if (args == null) {
            args = Collections.emptyList();
        }
        UMLReflection uml = this.getEnvironment().getUMLReflection();
        LinkedHashSet operations = new LinkedHashSet(this.getOperations(owner));
        List matches = null;
        for (EOperation oper : operations) {
            if (owner instanceof VoidType && oper instanceof ImperativeOperation && QvtOperationalParserUtil.getContextualType((ImperativeOperation)oper) != owner || !name.equals(uml.getName((Object)oper)) || !this.matchArgs(owner, uml.getParameters((Object)oper), args)) continue;
            if (matches == null) {
                matches = new UniqueEList(3);
            }
            matches.add(oper);
        }
        if (matches != null) {
            if (matches.size() == 1) {
                return (EOperation)matches.get(0);
            }
            if (!matches.isEmpty()) {
                return this.getMostSpecificOperation(matches, args);
            }
        }
        if (owner == this.fOCLStdlib.getOclVoid() || owner == this.fOCLStdlib.getOclInvalid()) {
            return this.findOperationForVoidOrInvalid(owner, name, args);
        }
        return null;
    }

    public EStructuralFeature findAttribute(EClassifier owner, String name) {
        EStructuralFeature aliasedProperty;
        EStructuralFeature property;
        EStructuralFeature eStructuralFeature = property = owner instanceof EClass ? ((EClass)owner).getEStructuralFeature(name) : null;
        if (property != null && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)owner, (Object)((EClassifier)this.getUMLReflection().getOwningClassifier((Object)property)))) {
            return property;
        }
        property = (EStructuralFeature)super.findAttribute((Object)owner, name);
        if (property == null && (aliasedProperty = this.getEnvironment().lookupPropertyAlias(owner, name)) != null) {
            String originalName = aliasedProperty.getName();
            return (EStructuralFeature)super.findAttribute((Object)owner, originalName);
        }
        return property;
    }

    public boolean isStandardLibraryFeature(EClassifier owner, Object feature) {
        return !(feature instanceof ImperativeOperation);
    }

    protected org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> resolveCollectionType(CollectionKind kind, EClassifier elementType) {
        return (org.eclipse.ocl.types.CollectionType)TypeUtil.resolveCollectionType((Environment)this.getEnvironment(), (CollectionKind)kind, (Object)elementType);
    }

    protected TupleType<EOperation, EStructuralFeature> resolveTupleType(EList<? extends TypedElement<EClassifier>> parts) {
        return (TupleType)TypeUtil.resolveTupleType((Environment)this.getEnvironment(), parts);
    }

    protected EClassifier resolve(EClassifier type) {
        return (EClassifier)TypeUtil.resolveType((Environment)this.getEnvironment(), (Object)type);
    }

    protected EClassifier resolveGenericType(EClassifier owner, EClassifier paramType, EClassifier argType) {
        CollectionType collectionType;
        if (paramType instanceof TemplateParameterType) {
            if (owner != null && owner.eClass() == ImperativeOCLPackage.eINSTANCE.getDictionaryType()) {
                DictionaryType dictionaryType = (DictionaryType)owner;
                if (this.getQVTEnvironment().getQVTStandardLibrary().getKeyT() == paramType) {
                    return dictionaryType.getKeyType();
                }
            }
            return argType;
        }
        EClassifier result = (EClassifier)super.resolveGenericType((Object)owner, (Object)paramType, (Object)argType);
        EClass listMetaType = ImperativeOCLPackage.eINSTANCE.getListType();
        if (owner != null && owner.eClass() == listMetaType && this.fOCLStdlib.getT() == result && (collectionType = (CollectionType)owner).getElementType() == this.fOCLStdlib.getOclVoid()) {
            return (EClassifier)this.fOCLStdlib.getOclVoid();
        }
        return result;
    }

    public EClassifier getResultType(Object problemObject, EClassifier owner, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
        if (this.isQVTOperation(operation)) {
            return this.fGenericResolver.resolveOperationReturnType(owner, operation, args);
        }
        return (EClassifier)super.getResultType(problemObject, (Object)owner, (Object)operation, args);
    }

    public int getRelationship(EClassifier type1, EClassifier type2) {
        QVTUMLReflection qvtUml = (QVTUMLReflection)this.getUMLReflection();
        Integer integer = qvtUml.getCachedRelationship(type1, type2);
        if (integer != null) {
            return integer;
        }
        int result = this.getRelationshipImpl(type1, type2);
        qvtUml.putCachedRelationship(type1, type2, result);
        return result;
    }

    private int getRelationshipImpl(EClassifier type1, EClassifier type2) {
        if (type1 == type2) {
            return 1;
        }
        if (type1 == null) {
            return 8;
        }
        boolean isList1 = type1 instanceof ListType;
        boolean isList2 = type2 instanceof ListType;
        if (isList1 || isList2) {
            if (isList1 && isList2) {
                ListType list1 = (ListType)type1;
                ListType list2 = (ListType)type2;
                return this.getRelationship((EClassifier)list1.getElementType(), (EClassifier)list2.getElementType());
            }
            if (!isList1 && type1 instanceof org.eclipse.ocl.types.CollectionType) {
                org.eclipse.ocl.types.CollectionType col1 = (org.eclipse.ocl.types.CollectionType)type1;
                if (col1.eClass() == EcorePackage.eINSTANCE.getCollectionType() && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((ListType)type2).getElementType()), (Object)((EClassifier)col1.getElementType()))) {
                    return 4;
                }
                if (col1.eClass() == EcorePackage.eINSTANCE.getSequenceType() && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((ListType)type2).getElementType()), (Object)((EClassifier)col1.getElementType()))) {
                    return 5;
                }
            } else if (!isList2 && type2 instanceof org.eclipse.ocl.types.CollectionType) {
                org.eclipse.ocl.types.CollectionType col2 = (org.eclipse.ocl.types.CollectionType)type2;
                if (col2.eClass() == EcorePackage.eINSTANCE.getCollectionType() && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((ListType)type1).getElementType()), (Object)((EClassifier)col2.getElementType()))) {
                    return 2;
                }
                if (col2.eClass() == EcorePackage.eINSTANCE.getSequenceType() && TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((ListType)type1).getElementType()), (Object)((EClassifier)col2.getElementType()))) {
                    return 3;
                }
            }
            if (this.isVoidOrInvalid(type1) || this.isVoidOrInvalid(type2)) {
                return super.getRelationship((Object)type1, (Object)type2);
            }
            return 8;
        }
        boolean isDict1 = type1 instanceof DictionaryType;
        boolean isDict2 = type2 instanceof DictionaryType;
        if (isDict1 || isDict2) {
            if (isDict1 && isDict2) {
                int keyRelShip;
                DictionaryType dict1 = (DictionaryType)type1;
                DictionaryType dict2 = (DictionaryType)type2;
                int elementRelShip = this.getRelationship((EClassifier)dict1.getElementType(), (EClassifier)dict2.getElementType());
                if (elementRelShip != (keyRelShip = this.getRelationship(dict1.getKeyType(), dict2.getKeyType()))) {
                    if ((keyRelShip & 3) != 0 && (elementRelShip & 3) != 0) {
                        return 2;
                    }
                    if ((keyRelShip & 5) != 0 && (elementRelShip & 5) != 0) {
                        return 4;
                    }
                    return elementRelShip;
                }
                return elementRelShip;
            }
            if (!isDict1) {
                if (type1.eClass() == EcorePackage.eINSTANCE.getCollectionType()) {
                    org.eclipse.ocl.types.CollectionType col1 = (org.eclipse.ocl.types.CollectionType)type1;
                    if (TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((DictionaryType)type2).getElementType()), (Object)((EClassifier)col1.getElementType()))) {
                        return 4;
                    }
                }
                if (this.isVoidOrInvalid(type1)) {
                    return super.getRelationship((Object)type1, (Object)type2);
                }
                return 8;
            }
            if (!isDict2) {
                if (type2.eClass() == EcorePackage.eINSTANCE.getCollectionType()) {
                    org.eclipse.ocl.types.CollectionType col2 = (org.eclipse.ocl.types.CollectionType)type1;
                    if (TypeUtil.compatibleTypeMatch((Environment)this.getEnvironment(), (Object)((EClassifier)((DictionaryType)type1).getElementType()), (Object)((EClassifier)col2.getElementType()))) {
                        return 2;
                    }
                }
                if (this.isVoidOrInvalid(type2)) {
                    return super.getRelationship((Object)type1, (Object)type2);
                }
                return 8;
            }
        }
        boolean isTuple1 = type1 instanceof TupleType;
        boolean isTuple2 = type2 instanceof TupleType;
        if (isTuple1 && isTuple2) {
            int currentRelation = 0;
            int matchingFeaturesCount = 0;
            EList features1 = ((TupleType)type1).oclProperties();
            EList features2 = ((TupleType)type2).oclProperties();
            for (EStructuralFeature feature1 : features1) {
                EStructuralFeature feature2 = this.findAttribute(type2, feature1.getName());
                if (feature2 == null) {
                    return 8;
                }
                int partRelShip = this.getRelationship(feature1.getEType(), feature2.getEType());
                if (partRelShip != 1) {
                    if (partRelShip == 7) {
                        currentRelation = 7;
                    } else if ((partRelShip & 2) != 0) {
                        currentRelation = (currentRelation & 4) != 0 ? 7 : (currentRelation |= partRelShip);
                    } else if ((partRelShip & 4) != 0) {
                        currentRelation = (currentRelation & 2) != 0 ? 7 : (currentRelation |= partRelShip);
                    } else {
                        return 8;
                    }
                }
                ++matchingFeaturesCount;
            }
            if (matchingFeaturesCount < features1.size() || features1.size() != features2.size()) {
                return 8;
            }
            return currentRelation == 0 ? 1 : currentRelation;
        }
        return super.getRelationship((Object)type1, (Object)type2);
    }

    public boolean compatibleTypeMatch(EClassifier type1, EClassifier type2) {
        switch (this.getRelationship(type1, type2)) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    EOperation getMostSpecificOperation(List<EOperation> matchingOpers, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        if (matchingOpers == null || matchingOpers.isEmpty()) {
            return null;
        }
        List ambiguous = null;
        EOperation mostSpecific = null;
        int i = 0;
        for (EOperation nextOper : matchingOpers) {
            if (i++ == 0) {
                mostSpecific = nextOper;
                continue;
            }
            Relation nextOperRelation = this.getMoreSpecificByParameters(mostSpecific, nextOper, args);
            if (nextOperRelation == null) continue;
            if (nextOperRelation == Relation.IDENTICAL) {
                Relation ownerRelation = this.getMoreSpecificType((EClassifier)this.getUMLReflection().getOwningClassifier((Object)mostSpecific), (EClassifier)this.getUMLReflection().getOwningClassifier((Object)nextOper));
                if (Relation.IDENTICAL == ownerRelation) {
                    EOperation overriding = TypeCheckerImpl.selectOverridingOperation(mostSpecific, nextOper);
                    if (overriding != null) {
                        mostSpecific = overriding;
                    } else {
                        Module resolvingModule = this.getEnvironment().getModuleContextType();
                        if (resolvingModule != null) {
                            Module owningModule = QvtOperationalParserUtil.getOwningModule(mostSpecific);
                            Module nextOwningModule = QvtOperationalParserUtil.getOwningModule(nextOper);
                            if (owningModule == null || nextOwningModule == null) {
                                if (owningModule != null) {
                                    mostSpecific = nextOper;
                                }
                                nextOperRelation = Relation.AMBIGUOUS;
                            } else if (owningModule != resolvingModule && nextOwningModule != resolvingModule) {
                                nextOperRelation = Relation.AMBIGUOUS;
                            } else if (nextOwningModule == resolvingModule) {
                                mostSpecific = nextOper;
                            }
                        }
                    }
                } else if (Relation.LESS == ownerRelation) {
                    mostSpecific = nextOper;
                } else if (ownerRelation == null) {
                    continue;
                }
            } else if (nextOperRelation == Relation.LESS) {
                mostSpecific = nextOper;
            }
            if (nextOperRelation != Relation.AMBIGUOUS) continue;
            if (ambiguous == null) {
                ambiguous = new UniqueEList();
            }
            ambiguous.add(mostSpecific);
            ambiguous.add(nextOper);
        }
        if (ambiguous != null) {
            throw new AmbiguousLookupException(ValidationMessages.AmbiguousOperationLookup, ambiguous);
        }
        return mostSpecific != null ? mostSpecific : matchingOpers.get(0);
    }

    private static EOperation selectOverridingOperation(EOperation o1, EOperation o2) {
        if (o1 instanceof ImperativeOperation) {
            ImperativeOperation imp1 = (ImperativeOperation)o1;
            if (o2 != null && imp1.getOverridden() == o2) {
                return o1;
            }
        }
        if (o2 instanceof ImperativeOperation) {
            ImperativeOperation imp2 = (ImperativeOperation)o2;
            if (o1 != null && imp2.getOverridden() == o1) {
                return o2;
            }
        }
        return null;
    }

    private Relation getMoreSpecificByParameters(EOperation o1, EOperation o2, List<? extends TypedElement<EClassifier>> args) {
        if (o1 == o2) {
            return Relation.IDENTICAL;
        }
        EList params1 = o1.getEParameters();
        EList params2 = o2.getEParameters();
        assert (params1.size() == params2.size());
        if (params1.isEmpty()) {
            return Relation.IDENTICAL;
        }
        Relation resultParamRel = null;
        int i = 0;
        for (EParameter nextParam : params1) {
            EParameter nextParam2 = (EParameter)params2.get(i);
            Relation nextParamRel = this.getMoreSpecificType(nextParam.getEType(), nextParam2.getEType());
            if (nextParamRel == null) {
                return null;
            }
            if (nextParamRel == Relation.UNRELATED) {
                TypedElement<EClassifier> actualArg = args.get(i);
                if (this.fOCLStdlib.getOclVoid() == actualArg.getType() || this.fOCLStdlib.getOclInvalid() == actualArg.getType()) {
                    return Relation.AMBIGUOUS;
                }
                return null;
            }
            if (i++ == 0) {
                resultParamRel = nextParamRel;
                continue;
            }
            if (resultParamRel == nextParamRel || resultParamRel == Relation.IDENTICAL || nextParamRel == Relation.IDENTICAL) continue;
            return Relation.AMBIGUOUS;
        }
        return resultParamRel;
    }

    private Relation getMoreSpecificType(EClassifier t1, EClassifier t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        int relationship = this.getRelationship(t1, t2);
        switch (relationship) {
            case 2: {
                return Relation.MORE;
            }
            case 4: {
                return Relation.LESS;
            }
            case 1: {
                return Relation.IDENTICAL;
            }
        }
        return Relation.UNRELATED;
    }

    private EOperation findOperationForVoidOrInvalid(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        EClassifier argType;
        EOperation result = null;
        if (args.size() == 1 && (argType = (EClassifier)args.get(0).getType()) != owner && argType != null) {
            result = this.findMostSpecificOperationMatching(argType, name, args);
        }
        return result;
    }

    private boolean isQVTOperation(EOperation operation) {
        return QvtOperationalParserUtil.getOwningModule(operation) != null;
    }

    private boolean isVoidOrInvalid(EClassifier type1) {
        return type1 == this.fOCLStdlib.getOclVoid() || type1 == this.fOCLStdlib.getOclInvalid();
    }

    private QVTOEnvironment getQVTEnvironment() {
        return this.getEnvironment();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Relation {
        MORE,
        LESS,
        IDENTICAL,
        AMBIGUOUS,
        UNRELATED;

    }
}

