/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtValidator {
    private QvtValidator() {
    }

    public static IStatus validateTransformation(QvtTransformation transformation, List<TargetUriData> targetUris, String traceFilePath, boolean useTrace, ValidationType validationType) throws MdaException {
        IStatus result = StatusUtil.makeOkStatus();
        if (!transformation.hasEntryOperation()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_TransformaionMissedEntryOp, (Object)transformation.getModuleName()));
        }
        Iterator<TargetUriData> itrTargetData = targetUris.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (!itrTargetData.hasNext()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
            }
            IStatus nextStatus = QvtValidator.validateTransformationParameter(transfParam, itrTargetData.next(), transformation.getResourceSet(), validationType);
            if (nextStatus.getSeverity() <= result.getSeverity()) continue;
            result = nextStatus;
        }
        if (useTrace) {
            IStatus traceStatus = QvtValidator.validateTrace(traceFilePath, transformation.getResourceSet());
            if (StatusUtil.isError((IStatus)traceStatus)) {
                return traceStatus;
            }
            if (traceStatus.getSeverity() > result.getSeverity()) {
                result = traceStatus;
            }
        }
        return result;
    }

    public static IStatus validateTransformation(QvtTransformation transformation, List<ModelContent> inModels, String traceFileName) throws MdaException {
        IStatus result = StatusUtil.makeOkStatus();
        if (!transformation.hasEntryOperation()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_TransformaionMissedEntryOp, (Object)transformation.getModuleName()));
        }
        Iterator<ModelContent> itrInObjs = inModels.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.IN && transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.INOUT) continue;
            if (!itrInObjs.hasNext()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_MissedInputTransfParam, (Object)transfParam.getName()));
            }
            IStatus nextStatus = QvtValidator.validateTransformationParameterIn(transfParam, itrInObjs.next());
            if (nextStatus.getSeverity() <= result.getSeverity()) continue;
            result = nextStatus;
        }
        StringBuffer superfluousParams = new StringBuffer();
        while (itrInObjs.hasNext()) {
            ModelContent obj;
            if (superfluousParams.length() > 0) {
                superfluousParams.append(", ");
            }
            if ((obj = itrInObjs.next()) == null || obj.getContent().isEmpty()) continue;
            superfluousParams.append(EmfUtil.getFullName((EClassifier)((EObject)obj.getContent().get(0)).eClass()));
        }
        if (superfluousParams.length() > 0) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_SuperfluousInputTransfParam, (Object)superfluousParams.toString()));
        }
        if (traceFileName != null) {
            IStatus traceStatus = QvtValidator.validateTrace(traceFileName, transformation.getResourceSet());
            if (StatusUtil.isError((IStatus)traceStatus)) {
                return traceStatus;
            }
            if (traceStatus.getSeverity() > result.getSeverity()) {
                result = traceStatus;
            }
        }
        return result;
    }

    private static IStatus validateTransformationParameter(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS, ValidationType validationType) {
        if (transfParam.getMetamodels().isEmpty()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
        }
        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) {
            if (validationType == ValidationType.LIGHTWEIGHT_VALIDATION) {
                return QvtValidator.validateTransformationParameterInLightweight(transfParam, targetData, validationRS);
            }
            return QvtValidator.validateTransformationParameterIn(transfParam, targetData, validationRS);
        }
        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
            if (validationType == ValidationType.LIGHTWEIGHT_VALIDATION) {
                return QvtValidator.validateTransformationParameterInOutLightweight(transfParam, targetData, validationRS);
            }
            return QvtValidator.validateTransformationParameterInOut(transfParam, targetData, validationRS);
        }
        if (validationType == ValidationType.LIGHTWEIGHT_VALIDATION) {
            return QvtValidator.validateTransformationParameterOutLightweight(transfParam, targetData, validationRS);
        }
        return QvtValidator.validateTransformationParameterOut(transfParam, targetData, validationRS);
    }

    private static IStatus validateTrace(String traceFilePath, ResourceSet validationRS) {
        try {
            if (traceFilePath == null || traceFilePath.length() == 0) {
                return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_NoTraceFile);
            }
            URI traceUri = URI.createURI((String)traceFilePath);
            IStatus result = QvtValidator.canSaveEx(StatusUtil.makeOkStatus(), traceUri, validationRS);
            if (StatusUtil.isError((IStatus)result)) {
                return result;
            }
            if (!traceFilePath.endsWith(".qvtotrace") && result.getSeverity() < 2) {
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NoTraceFileExtension, (Object)".qvtotrace"));
            }
            return result;
        }
        catch (Exception e) {
            return StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)e);
        }
    }

    private static IStatus validateTransformationParameterIn(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        block23: {
            if (transfParam.getEntryType() != null) {
                EClassifier classifier = transfParam.getEntryType();
                URI sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
                EObject in = null;
                ResourceSet rs = classifier.eResource() != null && classifier.eResource().getResourceSet() != null ? classifier.eResource().getResourceSet() : validationRS;
                try {
                    ModelContent loadModel = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)rs);
                    in = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
                }
                catch (Exception loadModel) {
                    // empty catch block
                }
                if (in == null) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                }
                ResourceSet inputRs = rs == null ? in.eResource().getResourceSet() : null;
                try {
                    try {
                        in = EmfUtil.resolveSource(in, (EObject)classifier);
                    }
                    catch (WrappedException e) {
                        IStatus iStatus = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                        if (inputRs != null) {
                            EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                        }
                        return iStatus;
                    }
                    if (!EmfUtil.isAssignableFrom((EClassifier)classifier, (EClassifier)in.eClass()) || !classifier.isInstance((Object)in)) {
                        IStatus iStatus = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object)EmfUtil.getFullName((EClassifier)in.eClass()), (Object)EmfUtil.getFullName((EClassifier)classifier)));
                        return iStatus;
                    }
                    break block23;
                }
                finally {
                    if (inputRs != null) {
                        EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                    }
                }
            }
            EPackage metamodel = transfParam.getMetamodels().get(0);
            URI sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
            ModelContent in = null;
            ResourceSet rs = metamodel.eResource() != null && metamodel.eResource().getResourceSet() != null ? metamodel.eResource().getResourceSet() : validationRS;
            try {
                in = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)rs);
            }
            catch (Exception inputRs) {
                // empty catch block
            }
            if (in == null) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
            }
            ResourceSet inputRs = rs == null ? in.getResourceSet() : null;
            try {
                try {
                    in = in.getResolvedContent((EObject)metamodel);
                }
                catch (WrappedException e) {
                    IStatus iStatus = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                    if (inputRs != null) {
                        EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                    }
                    return iStatus;
                }
            }
            finally {
                if (inputRs != null) {
                    EmfUtil.cleanupResourceSet((ResourceSet)inputRs);
                }
            }
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterInLightweight(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        URI sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (sourceUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        if (!EmfUtil.isUriExists((URI)sourceUri, (ResourceSet)validationRS)) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterIn(QvtTransformation.TransformationParameter transfParam, ModelContent in) {
        if (transfParam.getMetamodels().isEmpty()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
        }
        if (transfParam.getEntryType() != null) {
            EObject inObj;
            EClassifier classifier = transfParam.getEntryType();
            EObject eObject = inObj = in != null && !in.getContent().isEmpty() ? (EObject)in.getContent().get(0) : null;
            if (inObj == null) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object)"<null>", (Object)EmfUtil.getFullName((EClassifier)classifier)));
            }
            if (!EmfUtil.isAssignableFrom((EClassifier)classifier, (EClassifier)inObj.eClass()) || !classifier.isInstance((Object)inObj)) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object)EmfUtil.getFullName((EClassifier)inObj.eClass()), (Object)EmfUtil.getFullName((EClassifier)classifier)));
            }
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterInOut(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        IStatus result = QvtValidator.validateTransformationParameterIn(transfParam, targetData, validationRS);
        if (result.getSeverity() >= 2) {
            return result;
        }
        URI sourceUri = URI.createURI((String)targetData.getUriString());
        result = QvtValidator.canSaveEx(result, sourceUri, validationRS);
        return result;
    }

    private static IStatus validateTransformationParameterInOutLightweight(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        IStatus result = QvtValidator.validateTransformationParameterInLightweight(transfParam, targetData, validationRS);
        if (result.getSeverity() >= 2) {
            return result;
        }
        URI sourceUri = URI.createURI((String)targetData.getUriString());
        result = QvtValidator.canSaveEx(result, sourceUri, validationRS);
        return result;
    }

    private static IStatus validateTransformationParameterOut(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        URI destUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (destUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)targetData.getUriString()));
        }
        IStatus result = StatusUtil.makeOkStatus();
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                IStatus canSave;
                if (EmfUtil.isUriExists((URI)destUri, (ResourceSet)validationRS) && result.getSeverity() < 2) {
                    result = EmfUtil.isUriExistsAsEObject((String)targetData.getUriString(), (ResourceSet)validationRS) ? StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri)) : StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExistsNonEObject, (Object)destUri));
                }
                if (StatusUtil.isError((IStatus)(canSave = QvtValidator.canSave(destUri, validationRS)))) {
                    return canSave;
                }
                if (canSave.getSeverity() > result.getSeverity()) {
                    result = canSave;
                }
                if (!destUri.hasFragment() || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NewDestinationHasFragment, (Object)destUri.fragment()));
                break;
            }
            case EXISTING_CONTAINER: {
                EObject eContainer;
                ModelContent loadModel = EmfUtil.loadModel((URI)destUri);
                EObject eObject = eContainer = loadModel != null && !loadModel.getContent().isEmpty() ? (EObject)loadModel.getContent().get(0) : null;
                if (eContainer == null) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)destUri));
                }
                if (StatusUtil.isError((IStatus)(result = QvtValidator.canSaveEx(result, destUri, validationRS)))) {
                    return result;
                }
                String feature = targetData.getFeature();
                if (feature == null || feature.trim().length() == 0) {
                    if (result.getSeverity() >= 2) break;
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri));
                    break;
                }
                EStructuralFeature eFeature = eContainer.eClass().getEStructuralFeature(feature);
                if (!(eFeature instanceof EReference)) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidFeature, (Object)feature));
                }
                EReference ref = (EReference)eFeature;
                if (ref.isChangeable()) break;
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidFeature, (Object)ref.getName()));
            }
            case INPLACE: {
                return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_InplaceConfigNotSupported);
            }
        }
        return result;
    }

    private static IStatus validateTransformationParameterOutLightweight(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        URI destUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (destUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)targetData.getUriString()));
        }
        IStatus result = StatusUtil.makeOkStatus();
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                IStatus canSave;
                if (EmfUtil.isUriExists((URI)destUri, (ResourceSet)validationRS) && result.getSeverity() < 2) {
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri));
                }
                if (StatusUtil.isError((IStatus)(canSave = QvtValidator.canSave(destUri, validationRS)))) {
                    return canSave;
                }
                if (canSave.getSeverity() > result.getSeverity()) {
                    result = canSave;
                }
                if (!destUri.hasFragment() || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NewDestinationHasFragment, (Object)destUri.fragment()));
                break;
            }
            case EXISTING_CONTAINER: {
                result = QvtValidator.canSaveEx(result, destUri, validationRS);
                if (StatusUtil.isError((IStatus)result)) {
                    return result;
                }
                String feature = targetData.getFeature();
                if (feature != null && feature.trim().length() != 0 || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri));
                break;
            }
            case INPLACE: {
                return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_InplaceConfigNotSupported);
            }
        }
        return result;
    }

    private static IStatus canSave(URI destUri, ResourceSet validationRS) {
        URIConverter uriConverter = validationRS != null ? validationRS.getURIConverter() : URIConverter.INSTANCE;
        URI converted = uriConverter.normalize(destUri);
        IStatus okStatus = StatusUtil.makeOkStatus();
        String scheme = converted.scheme();
        if (converted.isFile() && !"file".equals(scheme) && !"platform".equals(scheme)) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_UriNotFile, (Object[])new Object[]{destUri, scheme}));
        }
        return okStatus;
    }

    private static IStatus canSaveEx(IStatus result, URI destUri, ResourceSet validationRS) {
        IStatus canSave;
        IFile file = WorkspaceUtils.getWorkspaceFile((URI)destUri);
        if (file != null && file.exists() && file.isReadOnly() && result.getSeverity() < 2) {
            result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationReadonly, (Object)destUri));
        }
        if (StatusUtil.isError((IStatus)(canSave = QvtValidator.canSave(destUri, validationRS)))) {
            return canSave;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationType {
        FULL_VALIDATION,
        LIGHTWEIGHT_VALIDATION;

    }
}

