/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApiWithConfigKey;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FollowRedirectsTest
extends WiremockArquillianTest {
    private static final String FOLLOWED_REDIRECT = "followed redirect";
    private static final String DID_NOT_FOLLOW_REDIRECT = "did not follow redirect";
    private static final String LOCATION = "Location";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(FollowRedirectsTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{SimpleGetApi.class, SimpleGetApiWithConfigKey.class, WiremockArquillianTest.class});
    }

    @BeforeMethod
    public void reset() {
        WireMock.reset();
    }

    @Test
    public void test301Default() throws Exception {
        FollowRedirectsTest.testDefault(301, this.getDefaultClientInstance());
    }

    @Test
    public void test301Follows() throws Exception {
        FollowRedirectsTest.testFollows(301, this.getConfiguredClientInstance());
    }

    @Test
    public void test302Default() throws Exception {
        FollowRedirectsTest.testDefault(302, this.getDefaultClientInstance());
    }

    @Test
    public void test302Follows() throws Exception {
        FollowRedirectsTest.testFollows(302, this.getConfiguredClientInstance());
    }

    @Test
    public void test303Default() throws Exception {
        FollowRedirectsTest.testDefault(303, this.getDefaultClientInstance());
    }

    @Test
    public void test303Follows() throws Exception {
        FollowRedirectsTest.testFollows(303, this.getConfiguredClientInstance());
    }

    @Test
    public void test307Default() throws Exception {
        FollowRedirectsTest.testDefault(307, this.getDefaultClientInstance());
    }

    @Test
    public void test307Follows() throws Exception {
        FollowRedirectsTest.testFollows(307, this.getConfiguredClientInstance());
    }

    protected SimpleGetApi getDefaultClientInstance() {
        return (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(FollowRedirectsTest.getServerURI()).build(SimpleGetApi.class);
    }

    protected SimpleGetApiWithConfigKey getConfiguredClientInstance() {
        return (SimpleGetApiWithConfigKey)RestClientBuilder.newBuilder().baseUri(FollowRedirectsTest.getServerURI()).followRedirects(true).build(SimpleGetApiWithConfigKey.class);
    }

    public static void testDefault(int redirectCode, SimpleGetApi defaultClient) throws Exception {
        try (Response response = FollowRedirectsTest.execute(defaultClient, redirectCode);){
            Assert.assertEquals((int)response.getStatus(), (int)redirectCode);
            Assert.assertEquals((String)response.getHeaderString(LOCATION), (String)(FollowRedirectsTest.getStringURL() + "redirected"));
            Assert.assertEquals((String)((String)response.readEntity(String.class)), (String)DID_NOT_FOLLOW_REDIRECT);
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")));
            WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/redirected")));
        }
    }

    public static void testFollows(int redirectCode, SimpleGetApi followingClient) throws Exception {
        try (Response response = FollowRedirectsTest.execute(followingClient, redirectCode);){
            Assert.assertEquals((int)response.getStatus(), (int)200);
            Assert.assertNull((Object)response.getHeaderString(LOCATION));
            Assert.assertEquals((String)((String)response.readEntity(String.class)), (String)FOLLOWED_REDIRECT);
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")));
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/redirected")));
        }
    }

    private static Response execute(SimpleGetApi simpleGetApi, int redirectCode) throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(redirectCode).withBody(DID_NOT_FOLLOW_REDIRECT).withHeader(LOCATION, new String[]{FollowRedirectsTest.getStringURL() + "redirected"})));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/redirected")).willReturn(WireMock.aResponse().withStatus(200).withBody(FOLLOWED_REDIRECT)));
        return simpleGetApi.executeGet();
    }
}

