/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PeekStageVerification
extends AbstractStageVerification {
    PeekStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void peekStageShouldNotModifyElements() {
        AtomicInteger count = new AtomicInteger();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).peek(i -> count.incrementAndGet()).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertEquals((int)count.get(), (int)3);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void peekStageShouldHandleExceptions() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).peek(x -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void peekStageShouldPropagateUpstreamExceptions() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).peek(x -> {}).toList().run(this.getEngine()));
    }

    public void peekStageShouldNotBeExecutedForEmptyStreams() {
        AtomicBoolean invoked = new AtomicBoolean();
        this.await(this.rs.empty().peek(x -> invoked.set(true)).toList().run(this.getEngine()));
        Assert.assertFalse((boolean)invoked.get());
    }

    @Test
    public void peekStageShouldBeReusable() {
        ProcessorBuilder peek = this.rs.builder().peek(t -> {});
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).via(peek).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{4, 5, 6}).via(peek).toList().run(this.getEngine()))), Arrays.asList(4, 5, 6));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        private Consumer<Integer> noop = x -> {};

        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return PeekStageVerification.this.rs.builder().peek(this.noop).buildRs(PeekStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return PeekStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).peek(this.noop).buildRs(PeekStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

