/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SkipStageVerification
extends AbstractStageVerification {
    SkipStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void skipStageShouldSkipElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).skip(2L).toList().run(this.getEngine()))), Arrays.asList(3, 4));
    }

    @Test
    public void skipStageShouldSupportSkippingNoElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).skip(0L).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3, 4));
    }

    @Test
    public void skipStageShouldBeReusable() {
        ProcessorBuilder skip = this.rs.builder().skip(2L);
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4}).via(skip).toList().run(this.getEngine()))), Arrays.asList(3, 4));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{5, 6, 7, 8}).via(skip).toList().run(this.getEngine()))), Arrays.asList(7, 8));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        ProcessorVerification() {
        }

        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return SkipStageVerification.this.rs.builder().skip(0L).buildRs(SkipStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return SkipStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).skip(1L).buildRs(SkipStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

