/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.metrics;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.junit.Assert;
import org.reactivestreams.Publisher;

@ApplicationScoped
@Connector(value="test-connector")
public class TestConnector
implements IncomingConnectorFactory,
OutgoingConnectorFactory {
    public static final String ID = "test-connector";
    private Map<String, FlowableEmitter<Message<String>>> incomingEmitters = new HashMap<String, FlowableEmitter<Message<String>>>();
    private Map<String, LinkedBlockingQueue<Message<String>>> outgoingQueues = new HashMap<String, LinkedBlockingQueue<Message<String>>>();

    public SubscriberBuilder<? extends Message<String>, Void> getSubscriberBuilder(Config config) {
        String channel = (String)config.getValue("channel-name", String.class);
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.outgoingQueues.put(channel, queue);
        return ReactiveStreams.builder().forEach(queue::add);
    }

    public PublisherBuilder<? extends Message<String>> getPublisherBuilder(Config config) {
        String channel = (String)config.getValue("channel-name", String.class);
        Flowable flowable = Flowable.create(e -> this.incomingEmitters.put(channel, (FlowableEmitter<Message<String>>)e), (BackpressureStrategy)BackpressureStrategy.BUFFER);
        return ReactiveStreams.fromPublisher((Publisher)flowable);
    }

    public void send(String channel, Message<String> message) {
        FlowableEmitter<Message<String>> emitter = this.incomingEmitters.get(channel);
        if (emitter == null) {
            throw new RuntimeException("No such incoming channel registered: " + channel);
        }
        emitter.onNext(message);
    }

    public Message<String> get(String channel) {
        LinkedBlockingQueue<Message<String>> queue = this.outgoingQueues.get(channel);
        if (queue == null) {
            throw new RuntimeException("No such outgoing channel registered: " + channel);
        }
        Message<String> result = null;
        try {
            result = queue.poll(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while waiting for messages");
        }
        if (result == null) {
            Assert.fail((String)"Timed out waiting for messages");
        }
        return result;
    }
}

