/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OASConfigServersTest
extends AppTestBase {
    private ValidatableResponse vr;

    @Deployment(name="airlines")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"airlines.war")).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.apps.airlines"})).addAsManifestResource("server-microprofile-config.properties", "microprofile-config.properties");
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testServer(String type) throws InterruptedException {
        this.vr = this.callEndpoint(type);
        this.vr.body("servers.findAll { it }.url", Matchers.hasSize((int)2), new Object[0]);
        this.vr.body("servers.findAll { it }.url", Matchers.containsInAnyOrder((Object[])new String[]{"https://xyz.com/v1", "https://abc.com/v1"}), new Object[0]);
        this.vr.body("paths.'/bookings/{id}'.servers.findAll { it }.url", Matchers.hasSize((int)2), new Object[0]);
        this.vr.body("paths.'/bookings/{id}'.servers.findAll { it }.url", Matchers.containsInAnyOrder((Object[])new String[]{"https://xyz.io/v1", "https://xyz.io/v2"}), new Object[0]);
        this.vr.body("paths.'/user/createWithArray'.servers.findAll { it }.url", Matchers.hasSize((int)1), new Object[0]);
        this.vr.body("paths.'/user/createWithArray'.servers.findAll { it }.url", Matchers.contains((Object[])new String[]{"https://xyz.io/v3"}), new Object[0]);
        this.vr.body("paths.'/bookings/{id}'.get.servers.findAll { it }.url", Matchers.hasSize((int)1), new Object[0]);
        this.vr.body("paths.'/bookings/{id}'.get.servers.findAll { it }.url", Matchers.contains((Object[])new String[]{"https://abc.io/v1"}), new Object[0]);
        this.vr.body("paths.'/reviews'.post.servers.findAll { it }.url", Matchers.hasSize((int)2), new Object[0]);
        this.vr.body("paths.'/reviews'.post.servers.findAll { it }.url", Matchers.containsInAnyOrder((Object[])new String[]{"https://newreviewserver.io/v1", "https://newreviewserver.io/v2"}), new Object[0]);
    }
}

