(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "./dockerMarkdown", "./dockerPlainText"], factory);
    }
})(function (require, exports) {
    /* --------------------------------------------------------------------------------------------
    * Copyright (c) Remy Suen. All rights reserved.
    * Licensed under the MIT License. See License.txt in the project root for license information.
    * ------------------------------------------------------------------------------------------ */
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DockerCompletion = void 0;
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var dockerMarkdown_1 = require("./dockerMarkdown");
    var dockerPlainText_1 = require("./dockerPlainText");
    var DockerCompletion = /** @class */ (function () {
        function DockerCompletion() {
            this.dockerMarkdown = new dockerMarkdown_1.MarkdownDocumentation();
            this.dockerPlainText = new dockerPlainText_1.PlainTextDocumentation();
        }
        DockerCompletion.prototype.resolveCompletionItem = function (item, documentationFormat) {
            if (!item.documentation && item.data) {
                if (documentationFormat === undefined || documentationFormat === null) {
                    item.documentation = this.dockerPlainText.getDocumentation(item.data);
                }
                else {
                    for (var _i = 0, documentationFormat_1 = documentationFormat; _i < documentationFormat_1.length; _i++) {
                        var format = documentationFormat_1[_i];
                        if (format === vscode_languageserver_types_1.MarkupKind.PlainText) {
                            item.documentation = {
                                kind: vscode_languageserver_types_1.MarkupKind.PlainText,
                                value: this.dockerPlainText.getDocumentation(item.data)
                            };
                            return item;
                        }
                        else if (format === vscode_languageserver_types_1.MarkupKind.Markdown) {
                            item.documentation = {
                                kind: vscode_languageserver_types_1.MarkupKind.Markdown,
                                value: this.dockerMarkdown.getMarkdown(item.data).contents
                            };
                            return item;
                        }
                    }
                    // no known format detected, just use plain text then
                    item.documentation = this.dockerPlainText.getDocumentation(item.data);
                }
            }
            return item;
        };
        return DockerCompletion;
    }());
    exports.DockerCompletion = DockerCompletion;
});
