/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.views;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.swt.widgets.TableColumn;

public class VagrantBoxComparator
extends ViewerComparator {
    private final TableViewer tableViewer;
    private int sortColumnIndex;
    private int sortDirection;

    public VagrantBoxComparator(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void setColumn(TableColumn sortColumn) {
        TableColumn[] tableColumns = this.tableViewer.getTable().getColumns();
        int newSortColumnIndex = 0;
        for (int i = 0; i < tableColumns.length; ++i) {
            if (this.tableViewer.getTable().getColumns()[i] != sortColumn) continue;
            newSortColumnIndex = i;
            break;
        }
        this.sortDirection = this.sortColumnIndex != newSortColumnIndex ? 128 : (this.sortDirection == 128 ? 1024 : 128);
        this.sortColumnIndex = newSortColumnIndex;
        this.tableViewer.getTable().setSortColumn(sortColumn);
        this.tableViewer.getTable().setSortDirection(this.sortDirection);
    }

    public int getDirection() {
        return this.sortDirection;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof IVagrantBox) || !(e2 instanceof IVagrantBox)) {
            return 0;
        }
        int tmp = this.compareByColumn((IVagrantBox)e1, (IVagrantBox)e2);
        return tmp * this.sortDirection;
    }

    private int compareByColumn(IVagrantBox image1, IVagrantBox image2) {
        ColumnLabelProvider sortColumnLabelProvider = (ColumnLabelProvider)this.tableViewer.getLabelProvider(this.sortColumnIndex);
        String image1ColumnValue = sortColumnLabelProvider.getText((Object)image1);
        String image2ColumnValue = sortColumnLabelProvider.getText((Object)image2);
        if (this.sortDirection == 128) {
            return image1ColumnValue.compareToIgnoreCase(image2ColumnValue);
        }
        return -image1ColumnValue.compareToIgnoreCase(image2ColumnValue);
    }
}

