/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;

public class SRPMImportOperation
implements IRunnableWithProgress {
    private IProject project;
    private File sourceRPM;
    private URL remoteSRPM;
    private RPMProjectLayout projectLayout;
    private List<CoreException> rpmErrorTable;

    public SRPMImportOperation(IProject project, File sourceRPM, RPMProjectLayout rpmProjectLayout) {
        this.project = project;
        this.sourceRPM = sourceRPM;
        this.projectLayout = rpmProjectLayout;
    }

    public SRPMImportOperation(IProject project, URL sourceRPM, RPMProjectLayout rpmProjectLayout) {
        this.remoteSRPM = sourceRPM;
        this.project = project;
        this.projectLayout = rpmProjectLayout;
    }

    public void run(IProgressMonitor progressMonitor) {
        int totalWork = 3;
        this.rpmErrorTable = new ArrayList<CoreException>();
        progressMonitor.beginTask(Messages.getString("SRPMImportOperation.Starting"), totalWork);
        try {
            RPMProject rpmProject = new RPMProject(this.project, this.projectLayout);
            progressMonitor.worked(1);
            progressMonitor.setTaskName(Messages.getString("SRPMImportOperation.Importing_SRPM"));
            if (this.sourceRPM != null) {
                rpmProject.importSourceRPM(this.sourceRPM);
                progressMonitor.worked(2);
            } else if (this.remoteSRPM != null) {
                SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1);
                rpmProject.importSourceRPM(this.remoteSRPM, (IProgressMonitor)submonitor);
                progressMonitor.worked(2);
            }
        }
        catch (CoreException e) {
            this.rpmErrorTable.add(e);
        }
        progressMonitor.worked(2);
    }

    public MultiStatus getStatus() {
        IStatus[] errors = new IStatus[this.rpmErrorTable.size()];
        int iCount = 0;
        for (CoreException ex : this.rpmErrorTable) {
            errors[iCount] = ex.getStatus();
            ++iCount;
        }
        return new MultiStatus("org.eclipse.ui", 0, errors, Messages.getString("SRPMImportOperation.3"), null);
    }
}

