/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.maven.enricher.api.util.InitContainerHandler;

public class AutoTLSEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "jkube-openshift-autotls";
    static final String AUTOTLS_ANNOTATION_KEY = "service.alpha.openshift.io/serving-cert-secret-name";
    private String secretName = this.getConfig(Config.tlsSecretName, this.getContext().getGav().getArtifactId() + "-tls");
    private final InitContainerHandler initContainerHandler;

    public AutoTLSEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
        this.initContainerHandler = new InitContainerHandler(buildContext.getLog());
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (!this.isOpenShiftMode()) {
            return;
        }
        builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

            public void visit(PodSpecBuilder builder) {
                String tlsSecretVolumeName = AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeName);
                if (!this.isVolumeAlreadyExists(builder.buildVolumes(), tlsSecretVolumeName)) {
                    ((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)((PodSpecFluent.VolumesNested)builder.addNewVolume().withName(tlsSecretVolumeName)).withNewSecret().withSecretName(AutoTLSEnricher.this.secretName)).endSecret()).endVolume();
                }
                String jksSecretVolumeName = AutoTLSEnricher.this.getConfig(Config.jksVolumeName);
                if (!this.isVolumeAlreadyExists(builder.buildVolumes(), jksSecretVolumeName)) {
                    ((PodSpecFluent.VolumesNested)((VolumeFluent.EmptyDirNested)((PodSpecFluent.VolumesNested)builder.addNewVolume().withName(jksSecretVolumeName)).withNewEmptyDir().withMedium("Memory")).endEmptyDir()).endVolume();
                }
            }

            private boolean isVolumeAlreadyExists(List<Volume> volumes, String volumeName) {
                for (Volume v : volumes) {
                    if (!volumeName.equals(v.getName())) continue;
                    return true;
                }
                return false;
            }
        });
        builder.accept((Visitor)new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder builder) {
                String tlsSecretVolumeName = AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeName);
                if (!this.isVolumeMountAlreadyExists(builder.buildVolumeMounts(), tlsSecretVolumeName)) {
                    ((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)builder.addNewVolumeMount().withName(tlsSecretVolumeName)).withMountPath(AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeMountPoint))).withReadOnly(Boolean.valueOf(true))).endVolumeMount();
                }
                String jksVolumeName = AutoTLSEnricher.this.getConfig(Config.jksVolumeName);
                if (!this.isVolumeMountAlreadyExists(builder.buildVolumeMounts(), jksVolumeName)) {
                    ((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)builder.addNewVolumeMount().withName(jksVolumeName)).withMountPath(AutoTLSEnricher.this.getConfig(Config.jksVolumeMountPoint))).withReadOnly(Boolean.valueOf(true))).endVolumeMount();
                }
            }

            private boolean isVolumeMountAlreadyExists(List<VolumeMount> volumes, String volumeName) {
                for (VolumeMount v : volumes) {
                    if (!volumeName.equals(v.getName())) continue;
                    return true;
                }
                return false;
            }
        });
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder service) {
                ((ServiceFluent.MetadataNested)service.editOrNewMetadata().addToAnnotations(AutoTLSEnricher.AUTOTLS_ANNOTATION_KEY, AutoTLSEnricher.this.secretName)).endMetadata();
            }
        });
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (!this.isOpenShiftMode()) {
            return;
        }
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                AutoTLSEnricher.this.initContainerHandler.appendInitContainer(builder, this.createInitContainer());
            }

            private Container createInitContainer() {
                return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(AutoTLSEnricher.this.getConfig(Config.pemToJKSInitContainerName))).withImage(AutoTLSEnricher.this.getConfig(Config.pemToJKSInitContainerImage))).withImagePullPolicy("IfNotPresent")).withArgs(this.createArgsArray())).withVolumeMounts(this.createMounts())).build();
            }

            private List<String> createArgsArray() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("-cert-file");
                ret.add(AutoTLSEnricher.this.getConfig(Config.keystoreCertAlias) + "=/tls-pem/tls.crt");
                ret.add("-key-file");
                ret.add(AutoTLSEnricher.this.getConfig(Config.keystoreCertAlias) + "=/tls-pem/tls.key");
                ret.add("-keystore");
                ret.add("/tls-jks/" + AutoTLSEnricher.this.getConfig(Config.keystoreFileName));
                ret.add("-keystore-password");
                ret.add(AutoTLSEnricher.this.getConfig(Config.keystorePassword));
                return ret;
            }

            private List<VolumeMount> createMounts() {
                VolumeMount pemMountPoint = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeName))).withMountPath("/tls-pem")).build();
                VolumeMount jksMountPoint = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(AutoTLSEnricher.this.getConfig(Config.jksVolumeName))).withMountPath("/tls-jks")).build();
                return Arrays.asList(pemMountPoint, jksMountPoint);
            }
        });
    }

    static enum Config implements Configs.Key
    {
        tlsSecretName,
        tlsSecretVolumeMountPoint{
            {
                this.d = "/var/run/secrets/jkube.io/tls-pem";
            }
        }
        ,
        tlsSecretVolumeName{
            {
                this.d = "tls-pem";
            }
        }
        ,
        jksVolumeMountPoint{
            {
                this.d = "/var/run/secrets/jkube.io/tls-jks";
            }
        }
        ,
        jksVolumeName{
            {
                this.d = "tls-jks";
            }
        }
        ,
        pemToJKSInitContainerImage{
            {
                this.d = "jimmidyson/pemtokeystore:v0.1.0";
            }
        }
        ,
        pemToJKSInitContainerName{
            {
                this.d = "tls-jks-converter";
            }
        }
        ,
        keystoreFileName{
            {
                this.d = "keystore.jks";
            }
        }
        ,
        keystorePassword{
            {
                this.d = "changeit";
            }
        }
        ,
        keystoreCertAlias{
            {
                this.d = "server";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

