/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.maven.enricher.api.util.InitContainerHandler;

public class VolumePermissionEnricher
extends BaseEnricher {
    public static final String ENRICHER_NAME = "jkube-volume-permission";
    static final String VOLUME_STORAGE_CLASS_ANNOTATION = "volume.beta.kubernetes.io/storage-class";
    private final InitContainerHandler initContainerHandler;

    public VolumePermissionEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
        this.initContainerHandler = new InitContainerHandler(buildContext.getLog());
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                PodSpec podSpec = builder.buildSpec();
                if (podSpec == null) {
                    return;
                }
                if (!this.checkForPvc(podSpec)) {
                    return;
                }
                List containers = podSpec.getContainers();
                if (containers == null || containers.isEmpty()) {
                    return;
                }
                VolumePermissionEnricher.this.log.verbose("Adding init container for changing persistent volumes access mode to %s", new Object[]{VolumePermissionEnricher.this.getConfig(Config.permission)});
                if (!VolumePermissionEnricher.this.initContainerHandler.hasInitContainer(builder, VolumePermissionEnricher.ENRICHER_NAME)) {
                    VolumePermissionEnricher.this.initContainerHandler.appendInitContainer(builder, this.createPvInitContainer(podSpec));
                }
            }

            private boolean checkForPvc(PodSpec podSpec) {
                List volumes = podSpec.getVolumes();
                if (volumes != null) {
                    for (Volume volume : volumes) {
                        PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                        if (persistentVolumeClaim == null) continue;
                        return true;
                    }
                }
                return false;
            }

            private Container createPvInitContainer(PodSpec podSpec) {
                Map<String, String> mountPoints = this.extractMountPoints(podSpec);
                return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(VolumePermissionEnricher.ENRICHER_NAME)).withImage("busybox")).withImagePullPolicy("IfNotPresent")).withCommand(this.createChmodCommandArray(mountPoints))).withVolumeMounts(this.createMounts(mountPoints))).build();
            }

            private List<String> createChmodCommandArray(Map<String, String> mountPoints) {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("chmod");
                ret.add(VolumePermissionEnricher.this.getConfig(Config.permission));
                LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(mountPoints.values());
                for (String name : uniqueNames) {
                    ret.add(name);
                }
                return ret;
            }

            private List<VolumeMount> createMounts(Map<String, String> mountPoints) {
                ArrayList<VolumeMount> ret = new ArrayList<VolumeMount>();
                for (Map.Entry<String, String> entry : mountPoints.entrySet()) {
                    JsonObject mount = new JsonObject();
                    mount.add("name", (JsonElement)new JsonPrimitive(entry.getKey()));
                    mount.add("mountPath", (JsonElement)new JsonPrimitive(entry.getValue()));
                    VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(entry.getKey())).withMountPath(entry.getValue())).build();
                    ret.add(volumeMount);
                }
                return ret;
            }

            private Map<String, String> extractMountPoints(PodSpec podSpec) {
                LinkedHashMap<String, String> nameToMount = new LinkedHashMap<String, String>();
                List volumes = podSpec.getVolumes();
                if (volumes != null) {
                    for (Volume volume : volumes) {
                        PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                        if (persistentVolumeClaim == null) continue;
                        String name = volume.getName();
                        String mountPath = this.getMountPath(podSpec.getContainers(), name);
                        nameToMount.put(name, mountPath);
                    }
                }
                return nameToMount;
            }

            private String getMountPath(List<Container> containers, String name) {
                for (Container container : containers) {
                    List volumeMounts = container.getVolumeMounts();
                    if (volumeMounts == null) continue;
                    for (VolumeMount volumeMount : volumeMounts) {
                        if (!name.equals(volumeMount.getName())) continue;
                        return volumeMount.getMountPath();
                    }
                }
                throw new IllegalArgumentException("No matching volume mount found for volume " + name);
            }
        });
        builder.accept((Visitor)new TypedVisitor<PersistentVolumeClaimBuilder>(){

            public void visit(PersistentVolumeClaimBuilder pvcBuilder) {
                String storageClass;
                if (pvcBuilder.buildMetadata() == null) {
                    pvcBuilder.withNewMetadata().endMetadata();
                }
                if (StringUtils.isNotBlank((CharSequence)(storageClass = VolumePermissionEnricher.this.getConfig(Config.defaultStorageClass)))) {
                    ((PersistentVolumeClaimFluent.MetadataNested)pvcBuilder.editMetadata().addToAnnotations(VolumePermissionEnricher.VOLUME_STORAGE_CLASS_ANNOTATION, storageClass)).endMetadata();
                }
            }
        });
    }

    static enum Config implements Configs.Key
    {
        permission{
            {
                this.d = "777";
            }
        }
        ,
        defaultStorageClass{
            {
                this.d = null;
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

