/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ServiceAccountConfig;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;

public class ServiceAccountEnricher
extends BaseEnricher {
    public ServiceAccountEnricher(JKubeEnricherContext enricherContext) {
        super((EnricherContext)enricherContext, "jkube-serviceaccount");
    }

    public void create(PlatformMode mode, final KubernetesListBuilder builder) {
        final HashMap<String, String> deploymentToSaPair = new HashMap<String, String>();
        final ArrayList<ServiceAccount> serviceAccounts = new ArrayList<ServiceAccount>();
        ResourceConfig xmlResourceConfig = this.getConfiguration().getResource().orElse(null);
        if (xmlResourceConfig != null && xmlResourceConfig.getServiceAccounts() != null) {
            for (ServiceAccountConfig serviceAccountConfig : xmlResourceConfig.getServiceAccounts()) {
                if (serviceAccountConfig.getName() != null) {
                    serviceAccounts.add(this.createServiceAccount(builder, serviceAccountConfig.getName()));
                }
                if (serviceAccountConfig.getDeploymentRef() == null) continue;
                deploymentToSaPair.put(serviceAccountConfig.getDeploymentRef(), serviceAccountConfig.getName());
            }
        }
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder deploymentBuilder) {
                String serviceAccountName = ServiceAccountEnricher.this.getServiceAccountNameFromSpec(deploymentBuilder);
                if (serviceAccountName != null && ServiceAccountEnricher.this.getServiceAccountFromList(builder, serviceAccountName) == null) {
                    serviceAccounts.add(ServiceAccountEnricher.this.createServiceAccount(builder, serviceAccountName));
                }
                if (deploymentToSaPair.containsKey(deploymentBuilder.buildMetadata().getName())) {
                    ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)deploymentBuilder.editSpec().editTemplate().editSpec().withServiceAccountName((String)deploymentToSaPair.get(deploymentBuilder.buildMetadata().getName()))).endSpec()).endTemplate()).endSpec();
                }
            }
        });
        builder.addAllToServiceAccountItems(serviceAccounts);
    }

    private ServiceAccount createServiceAccount(KubernetesListBuilder builder, String serviceAccountName) {
        return ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(serviceAccountName)).endMetadata()).build();
    }

    private String getServiceAccountNameFromSpec(DeploymentBuilder builder) {
        if (builder.buildSpec().getTemplate().getSpec().getServiceAccountName() != null) {
            return builder.buildSpec().getTemplate().getSpec().getServiceAccountName();
        }
        if (builder.buildSpec().getTemplate().getSpec().getServiceAccount() != null) {
            return builder.buildSpec().getTemplate().getSpec().getServiceAccount();
        }
        return null;
    }

    private ServiceAccount getServiceAccountFromList(KubernetesListBuilder builder, String serviceAccountName) {
        for (HasMetadata item : builder.buildItems()) {
            if (!(item instanceof ServiceAccount) || !item.getMetadata().getName().equals(serviceAccountName)) continue;
            return (ServiceAccount)item;
        }
        return null;
    }
}

