/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;

public class RevisionHistoryEnricher
extends BaseEnricher {
    public static final String DEFAULT_NAME = "jkube-revision-history";
    private static final String DEFAULT_NUMBER_OF_REVISIONS = "2";

    public RevisionHistoryEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, DEFAULT_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final Integer maxRevisionHistories = Configs.asInt((String)this.getConfig(Config.limit));
        this.log.info("Adding revision history limit to %s", new Object[]{maxRevisionHistories});
        if (platformMode == PlatformMode.kubernetes) {
            builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                public void visit(DeploymentBuilder item) {
                    ((DeploymentFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
                }
            });
        } else {
            builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

                public void visit(DeploymentConfigBuilder item) {
                    ((DeploymentConfigFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
                }
            });
        }
    }

    static enum Config implements Configs.Key
    {
        limit{
            {
                this.d = RevisionHistoryEnricher.DEFAULT_NUMBER_OF_REVISIONS;
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

