/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;

public class IngressEnricher
extends BaseEnricher {
    public IngressEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-ingress");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        if (platformMode == PlatformMode.kubernetes) {
            ArrayList ingresses = new ArrayList();
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    IngressEnricher.this.addIngress(listBuilder, serviceBuilder);
                }
            });
        }
    }

    private void addIngress(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder) {
        Integer servicePort;
        String name;
        ObjectMeta metadata = serviceBuilder.getMetadata();
        if (metadata != null && this.isExposedService(serviceBuilder) && !this.hasIngress(listBuilder, name = metadata.getName()) && (servicePort = this.getServicePort(serviceBuilder)) != null) {
            ResourceConfig resourceConfig = this.getConfiguration().getResource().orElse(null);
            IngressBuilder ingressBuilder = (IngressBuilder)((IngressBuilder)new IngressBuilder().withMetadata(serviceBuilder.getMetadata())).withNewSpec().endSpec();
            IngressSpecBuilder specBuilder = (IngressSpecBuilder)new IngressSpecBuilder().withBackend(((IngressBackendBuilder)((IngressBackendBuilder)new IngressBackendBuilder().withNewServiceName(name)).withNewServicePort(this.getServicePort(serviceBuilder))).build());
            if (resourceConfig != null) {
                specBuilder.addAllToRules((Collection)resourceConfig.getIngressRules());
            }
        }
    }

    private Integer getServicePort(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.getSpec();
        if (spec != null && (ports = spec.getPorts()) != null && ports.size() > 0) {
            for (ServicePort port : ports) {
                if (!port.getName().equals("http") && !port.getProtocol().equals("http")) continue;
                return port.getPort();
            }
            ServicePort servicePort = (ServicePort)ports.get(0);
            if (servicePort != null) {
                return servicePort.getPort();
            }
        }
        return null;
    }

    private boolean hasIngress(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept((Visitor)new TypedVisitor<IngressBuilder>(){

            public void visit(IngressBuilder builder) {
                ObjectMeta metadata = builder.getMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        });
        return answer.get();
    }

    private boolean isExposedService(ServiceBuilder serviceBuilder) {
        Service service = serviceBuilder.build();
        return this.isExposedService(service);
    }

    private boolean isExposedService(Service service) {
        ObjectMeta metadata = service.getMetadata();
        if (metadata != null) {
            Map labels = metadata.getLabels();
            if (labels != null && ("true".equals(labels.get("expose")) || "true".equals(labels.get(JKubeAnnotations.SERVICE_EXPOSE_URL.value())))) {
                return true;
            }
        } else {
            this.log.info("No Metadata for service! " + service, new Object[0]);
        }
        return false;
    }
}

