/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jkube.enricher.generic.SecretEnricher;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.maven.enricher.api.model.Configuration;
import org.eclipse.jkube.maven.enricher.api.util.SecretConstants;

public class DockerRegistrySecretEnricher
extends SecretEnricher {
    private static final String ANNOTATION_KEY = "maven.jkube.io/dockerServerId";
    private static final String ENRICHER_NAME = "jkube-docker-registry-secret";

    public DockerRegistrySecretEnricher(JKubeEnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    @Override
    protected String getAnnotationKey() {
        return ANNOTATION_KEY;
    }

    @Override
    protected Map<String, String> generateData(String dockerId) {
        Configuration config = this.getContext().getConfiguration();
        Optional secretConfig = config.getSecretConfiguration(dockerId);
        if (!secretConfig.isPresent()) {
            return null;
        }
        JsonObject params = new JsonObject();
        for (String key : new String[]{"username", "password", "email"}) {
            if (!((Map)secretConfig.get()).containsKey(key)) continue;
            params.add(key, (JsonElement)new JsonPrimitive(((Map)secretConfig.get()).get(key).toString()));
        }
        JsonObject ret = new JsonObject();
        ret.add(dockerId, (JsonElement)params);
        return Collections.singletonMap(SecretConstants.DOCKER_DATA_KEY, this.encode(ret.toString()));
    }
}

