/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JKubeProjectDependency;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.maven.enricher.api.model.KindAndName;
import org.eclipse.jkube.maven.enricher.api.util.KubernetesResourceUtil;

public class DependencyEnricher
extends BaseEnricher {
    private static String DEPENDENCY_KUBERNETES_YAML = "META-INF/jkube/kubernetes.yml";
    private static String DEPENDENCY_KUBERNETES_TEMPLATE_YAML = "META-INF/jkube/k8s-template.yml";
    private static String DEPENDENCY_OPENSHIFT_YAML = "META-INF/jkube/openshift.yml";
    private Set<URL> kubernetesDependencyArtifacts = new HashSet<URL>();
    private Set<URL> kubernetesTemplateDependencyArtifacts = new HashSet<URL>();
    private Set<URL> openshiftDependencyArtifacts = new HashSet<URL>();

    public DependencyEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-dependency");
        this.addArtifactsWithYaml(this.kubernetesDependencyArtifacts, DEPENDENCY_KUBERNETES_YAML);
        this.addArtifactsWithYaml(this.kubernetesTemplateDependencyArtifacts, DEPENDENCY_KUBERNETES_TEMPLATE_YAML);
        this.addArtifactsWithYaml(this.openshiftDependencyArtifacts, DEPENDENCY_OPENSHIFT_YAML);
    }

    private void addArtifactsWithYaml(Set<URL> artifactSet, String dependencyYaml) {
        List artifacts = this.getContext().getDependencies(this.isIncludeTransitive());
        for (JKubeProjectDependency artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            try {
                URL url = new URL("jar:" + file.toURI().toURL() + "!/" + dependencyYaml);
                artifactSet.add(url);
            }
            catch (MalformedURLException e) {
                this.getLog().debug("Failed to create URL for %s: %s", new Object[]{file, e});
            }
        }
        if (this.isIncludePlugin()) {
            Enumeration<URL> resources = null;
            try {
                resources = ((Object)((Object)this)).getClass().getClassLoader().getResources(dependencyYaml);
            }
            catch (IOException e) {
                this.getLog().error("Could not find %s on the classpath: %s", new Object[]{dependencyYaml, e});
            }
            if (resources != null) {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    artifactSet.add(url);
                }
            }
        }
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        switch (platformMode) {
            case kubernetes: {
                this.enrichKubernetes(builder);
                break;
            }
            case openshift: {
                this.enrichOpenShift(builder);
            }
        }
    }

    private void enrichKubernetes(KubernetesListBuilder builder) {
        ArrayList<HasMetadata> kubernetesItems = new ArrayList<HasMetadata>();
        this.processArtifactSetResources(this.kubernetesDependencyArtifacts, items -> {
            kubernetesItems.addAll(Arrays.asList(items.toArray(new HasMetadata[items.size()])));
            return null;
        });
        this.processArtifactSetResources(this.kubernetesTemplateDependencyArtifacts, items -> {
            List<HasMetadata> templates = Arrays.asList(items.toArray(new HasMetadata[items.size()]));
            for (HasMetadata resource : templates) {
                Template template;
                List objects;
                if (!(resource instanceof Template) || (objects = (template = (Template)resource).getObjects()) == null) continue;
                this.removeTemplateObjects(kubernetesItems, objects);
                kubernetesItems.addAll(objects);
            }
            return null;
        });
        this.filterAndAddItemsToBuilder(builder, kubernetesItems);
    }

    private void enrichOpenShift(KubernetesListBuilder builder) {
        ArrayList<HasMetadata> openshiftItems = new ArrayList<HasMetadata>();
        this.processArtifactSetResources(this.openshiftDependencyArtifacts, items -> {
            openshiftItems.addAll(Arrays.asList(items.toArray(new HasMetadata[0])));
            return null;
        });
        this.filterAndAddItemsToBuilder(builder, openshiftItems);
    }

    private void removeTemplateObjects(List<HasMetadata> list, List<HasMetadata> objects) {
        for (HasMetadata object : objects) {
            ArrayList<HasMetadata> copy = new ArrayList<HasMetadata>(list);
            for (HasMetadata resource : copy) {
                if (!Objects.equals(resource.getKind(), object.getKind()) || !Objects.equals(KubernetesHelper.getName((HasMetadata)object), KubernetesHelper.getName((HasMetadata)resource))) continue;
                list.remove(resource);
            }
        }
    }

    public void filterAndAddItemsToBuilder(KubernetesListBuilder builder, List<HasMetadata> items) {
        KindAndName aKey;
        HashMap<KindAndName, Integer> aIndexMap = new HashMap<KindAndName, Integer>();
        int nItems = 0;
        int index = 0;
        while (index < builder.getItems().size()) {
            HasMetadata aItem = (HasMetadata)builder.getItems().get(index);
            aKey = new KindAndName(aItem);
            aIndexMap.put(aKey, index);
            ++index;
            ++nItems;
        }
        for (HasMetadata item : items) {
            aKey = new KindAndName(item);
            if (aIndexMap.containsKey(aKey)) {
                HasMetadata duplicateItem = (HasMetadata)builder.getItems().get((Integer)aIndexMap.get(aKey));
                item = KubernetesResourceUtil.mergeResources((HasMetadata)item, (HasMetadata)duplicateItem, (KitLogger)this.log, (boolean)false);
                builder.setToItems(((Integer)aIndexMap.get(aKey)).intValue(), item);
                continue;
            }
            aIndexMap.put(aKey, nItems++);
            builder.addToItems(new HasMetadata[]{item});
        }
    }

    private void processArtifactSetResources(Set<URL> artifactSet, Function<List<HasMetadata>, Void> function) {
        for (URL url : artifactSet) {
            try {
                Template template;
                InputStream is = url.openStream();
                if (is == null) continue;
                this.log.debug("Processing Kubernetes YAML in at: %s", new Object[]{url});
                KubernetesList resources = (KubernetesList)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(is, KubernetesList.class);
                List items = resources.getItems();
                if (items.size() == 0 && Objects.equals("Template", resources.getKind()) && (template = (Template)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(is = url.openStream(), Template.class)) != null) {
                    items.add(template);
                }
                for (HasMetadata item : items) {
                    KubernetesResourceUtil.setSourceUrlAnnotationIfNotSet((HasMetadata)item, (String)url.toString());
                    this.log.debug("  found %s  %s", new Object[]{KubernetesHelper.getKind((HasMetadata)item), KubernetesHelper.getName((HasMetadata)item)});
                }
                function.apply(items);
            }
            catch (IOException e) {
                this.getLog().debug("Skipping %s: %s", new Object[]{url, e});
            }
        }
    }

    protected boolean isIncludePlugin() {
        return Configs.asBoolean((String)this.getConfig(Config.includePlugin));
    }

    protected boolean isIncludeTransitive() {
        return Configs.asBoolean((String)this.getConfig(Config.includeTransitive));
    }

    private static enum Config implements Configs.Key
    {
        includeTransitive{
            {
                this.d = "true";
            }
        }
        ,
        includePlugin{
            {
                this.d = "true";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

