/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectFluent;
import java.util.Arrays;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.maven.enricher.api.BaseEnricher;
import org.eclipse.jkube.maven.enricher.api.EnricherContext;
import org.eclipse.jkube.maven.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.maven.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.maven.enricher.handler.HandlerHub;

public class DefaultNamespaceEnricher
extends BaseEnricher {
    protected static final String[] NAMESPACE_KINDS = new String[]{"Project", "Namespace"};
    private final HandlerHub handlerHub;
    private final ResourceConfig config;

    public DefaultNamespaceEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-namespace");
        ResourceConfig xmlResourceConfig = this.getConfiguration().getResource().orElse(null);
        this.config = new ResourceConfig.Builder(xmlResourceConfig).build();
        this.handlerHub = new HandlerHub(this.getContext().getGav(), this.getContext().getConfiguration().getProperties());
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        String type;
        String name = this.config.getNamespace();
        if (name == null || name.isEmpty()) {
            return;
        }
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])NAMESPACE_KINDS) && ("project".equalsIgnoreCase(type = this.getConfig(Config.type)) || "namespace".equalsIgnoreCase(type))) {
            if (platformMode == PlatformMode.kubernetes) {
                this.log.info("Adding a default Namespace:" + this.config.getNamespace(), new Object[0]);
                Namespace namespace = this.handlerHub.getNamespaceHandler().getNamespace(this.config.getNamespace());
                builder.addToNamespaceItems(new Namespace[]{namespace});
            } else {
                this.log.info("Adding a default Project" + this.config.getNamespace(), new Object[0]);
                Project project = this.handlerHub.getProjectHandler().getProject(this.config.getNamespace());
                builder.addToProjectItems(new Project[]{project});
            }
        }
    }

    public void enrich(PlatformMode platformMode, final KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

            private String getNamespaceName() {
                String name = null;
                if (DefaultNamespaceEnricher.this.config.getNamespace() != null && !DefaultNamespaceEnricher.this.config.getNamespace().isEmpty()) {
                    name = DefaultNamespaceEnricher.this.config.getNamespace();
                }
                name = builder.getItems().stream().filter(item -> Arrays.asList(NAMESPACE_KINDS).contains(item.getKind())).findFirst().get().getMetadata().getName();
                return name;
            }

            public void visit(ObjectMetaBuilder metaBuilder) {
                if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])NAMESPACE_KINDS)) {
                    return;
                }
                String name = this.getNamespaceName();
                if (name == null || name.isEmpty()) {
                    return;
                }
                ((ObjectMetaBuilder)metaBuilder.withNamespace(name)).build();
            }
        });
        builder.accept((Visitor)new TypedVisitor<NamespaceBuilder>(){

            public void visit(NamespaceBuilder builder) {
                ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceBuilder)((NamespaceFluent.StatusNested)builder.withNewStatus().withPhase("Active")).endStatus()).editMetadata().withNamespace(null)).endMetadata()).build();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ProjectBuilder>(){

            public void visit(ProjectBuilder builder) {
                ((ProjectBuilder)((ProjectFluent.MetadataNested)((ProjectBuilder)((ProjectFluent.StatusNested)builder.withNewStatus().withPhase("Active")).endStatus()).editMetadata().withNamespace(null)).endMetadata()).build();
            }
        });
    }

    private static enum Config implements Configs.Key
    {
        name,
        type{
            {
                this.d = "namespace";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

