/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.dialogs;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.ui.behavior.fsm.Activator;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.ActionCodeEditorRegistry;
import org.eclipse.etrice.ui.behavior.fsm.actioneditor.IActionCodeEditor;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IFSMDialogFactory;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IMemberAwareConfiguration;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.ISelectionDialog;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.dialogs.AbstractPropertyDialog;
import org.eclipse.etrice.ui.common.base.dialogs.MultiValidator2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractMemberAwarePropertyDialog
extends AbstractPropertyDialog
implements IMemberAwareConfiguration {
    @Inject
    protected IFSMDialogFactory dialogFactory;
    private Control lastFocusedField = null;
    private Button members;
    private Button messages;
    private ModelComponent mc;
    private LastControlListener listener = new LastControlListener();
    private HashSet<Control> memberAware = new HashSet();
    private HashSet<Control> messageAware = new HashSet();
    private HashSet<Control> recvOnly = new HashSet();
    private HashMap<Control, IActionCodeEditor> actionEditorControlMap = new HashMap();

    public AbstractMemberAwarePropertyDialog(Shell shell, String title, ModelComponent mc) {
        super(shell, title);
        this.mc = mc;
    }

    public ModelComponent getModelComponent() {
        return this.mc;
    }

    protected void createMembersAndMessagesButtons(Composite body) {
        Composite buttonsArea = this.getToolkit().createComposite(body);
        buttonsArea.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        buttonsArea.setLayoutData((Object)gd);
        this.members = new Button(buttonsArea, 8);
        this.members.setText("Mem&bers");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.members.setLayoutData((Object)gd);
        this.members.setEnabled(false);
        this.members.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMembersPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMembersPressed();
            }
        });
        this.messages = new Button(buttonsArea, 8);
        this.messages.setText("Me&ssages");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.messages.setLayoutData((Object)gd);
        this.messages.setEnabled(false);
        this.messages.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMessagesPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMessagesPressed();
            }
        });
    }

    protected IActionCodeEditor createActionCodeEditor(Composite parent, String label, DetailCode detailCode, EObject obj, EStructuralFeature feat, IConverter s2m, IConverter m2s, IDetailExpressionProvider exprPovider) {
        return this.createActionCodeEditor(parent, label, detailCode, obj, feat, null, null, s2m, m2s, true, true, false, exprPovider);
    }

    protected IActionCodeEditor createActionCodeEditor(Composite parent, String label, DetailCode detailCode, EObject obj, EStructuralFeature feat, IValidator singleValidator, MultiValidator2 multiValidator, IConverter s2m, IConverter m2s, boolean useMembers, boolean useMessages, boolean useRecvMessagesOnly, IDetailExpressionProvider exprPovider) {
        Label l = this.getToolkit().createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String targetLanguage = store.getString("org.eclipse.etrice.ui.behavior.actioneditor.preferences.language");
        String editor = targetLanguage.equals("org.eclipse.etrice.ui.behavior.actioneditor.preferences.javalanguage") ? "org.eclipse.etrice.ui.behavior.actioneditor.preferences.javaeditor" : "org.eclipse.etrice.ui.behavior.actioneditor.preferences.cppeditor";
        String id = Activator.getDefault().getPreferenceStore().getString(editor);
        ActionCodeEditorRegistry.ActionCodeEditorRegistryEntry editorEntry = ActionCodeEditorRegistry.INSTANCE.getEditorWithId(id);
        if (editorEntry == null) {
            return null;
        }
        String editorText = FSMSupportUtil.getInstance().getFSMHelpers().getDetailCode(detailCode);
        IActionCodeEditor actionCodeEditor = editorEntry.newActionCodeEditor(parent, editorText, exprPovider);
        if (actionCodeEditor != null) {
            this.configureMemberAwareness(actionCodeEditor, useMembers, useMessages, useRecvMessagesOnly);
            this.getToolkit().adapt(actionCodeEditor.getControl(), true, true);
            UpdateValueStrategy t2m = null;
            UpdateValueStrategy m2t = null;
            if (singleValidator != null || s2m != null || m2s != null) {
                t2m = new UpdateValueStrategy();
                if (s2m != null) {
                    t2m.setConverter(s2m);
                }
                if (singleValidator != null) {
                    t2m.setAfterConvertValidator(singleValidator);
                    t2m.setBeforeSetValidator(singleValidator);
                }
                m2t = new UpdateValueStrategy();
                if (m2s != null) {
                    m2t.setConverter(m2s);
                }
                if (singleValidator != null) {
                    m2t.setAfterConvertValidator(singleValidator);
                    m2t.setBeforeSetValidator(singleValidator);
                }
            }
            Object type = s2m != null ? s2m.getToType() : String.class;
            this.createBinding((Widget)actionCodeEditor.getControl(), obj, feat, type, t2m, m2t, multiValidator);
        }
        return actionCodeEditor;
    }

    protected void handleMembersPressed() {
        ISelectionDialog dlg = this.dialogFactory.createMemberSelectionDialog(this.getShell(), this.mc);
        if (dlg.open() == 0) {
            this.insertText(dlg.getSelected());
        }
    }

    protected void handleMessagesPressed() {
        boolean receiveOnly = this.recvOnly.contains(this.lastFocusedField);
        ISelectionDialog dlg = this.dialogFactory.createMessageSelectionDialog(this.getShell(), this.mc, receiveOnly);
        if (dlg.open() == 0) {
            this.insertText(dlg.getSelected());
        }
    }

    private void insertText(String txt) {
        if (this.lastFocusedField != null) {
            if (this.actionEditorControlMap.containsKey(this.lastFocusedField)) {
                this.actionEditorControlMap.get(this.lastFocusedField).insertText(txt);
            } else if (this.lastFocusedField instanceof Text) {
                Text lastTextField = (Text)this.lastFocusedField;
                int begin = txt.indexOf(40);
                int end = txt.indexOf(41);
                int offset = lastTextField.getSelection().x;
                lastTextField.insert(txt);
                if (begin >= 0 && end >= 0 && end > begin + 1) {
                    lastTextField.setSelection(offset + begin + 1, offset + end);
                }
                lastTextField.setFocus();
            }
        }
    }

    @Override
    public void configureMemberAwareness(Control ctrl) {
        this.configureMemberAwareness(ctrl, false, false);
    }

    @Override
    public void configureMemberAwareness(Control ctrl, boolean useMembers, boolean useMessages) {
        this.configureMemberAwareness(ctrl, useMembers, useMembers, false);
    }

    @Override
    public void configureMemberAwareness(Control ctrl, boolean useMembers, boolean useMessages, boolean useRecvMessagesOnly) {
        if (useMembers) {
            this.memberAware.add(ctrl);
        }
        if (useMessages) {
            this.messageAware.add(ctrl);
        }
        if (useRecvMessagesOnly) {
            this.recvOnly.add(ctrl);
        }
        ctrl.addFocusListener((FocusListener)this.listener);
    }

    public void configureMemberAwareness(IActionCodeEditor actionCodeEditor, boolean useMembers, boolean useMessages, boolean useRecvMessagesOnly) {
        Control ctrl = actionCodeEditor.getControl();
        this.actionEditorControlMap.put(ctrl, actionCodeEditor);
        this.configureMemberAwareness(ctrl, useMembers, useMessages, useRecvMessagesOnly);
    }

    private class LastControlListener
    implements FocusListener {
        private LastControlListener() {
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof Control) {
                boolean enableMemberButton = AbstractMemberAwarePropertyDialog.this.memberAware.contains(e.getSource());
                boolean enableMessageButton = AbstractMemberAwarePropertyDialog.this.messageAware.contains(e.getSource());
                AbstractMemberAwarePropertyDialog.this.lastFocusedField = enableMemberButton || enableMessageButton ? (Control)e.getSource() : null;
                AbstractMemberAwarePropertyDialog.this.members.setEnabled(enableMemberButton);
                AbstractMemberAwarePropertyDialog.this.messages.setEnabled(enableMessageButton);
            } else {
                AbstractMemberAwarePropertyDialog.this.lastFocusedField = null;
                AbstractMemberAwarePropertyDialog.this.members.setEnabled(false);
                AbstractMemberAwarePropertyDialog.this.messages.setEnabled(false);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

