/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.builders;

import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class CombinedEdges {
    public final Event event;
    public final List<List<Edge>> sourceEdges;

    public CombinedEdges(Event event, List<Automaton> automs) {
        this.event = event;
        this.sourceEdges = Lists.listc((int)automs.size());
        boolean isUsed = false;
        int i = 0;
        while (i < automs.size()) {
            List le;
            if (automs.get((int)i).alphabet.contains(event)) {
                le = Lists.list();
                isUsed = true;
            } else {
                le = null;
            }
            this.sourceEdges.add(le);
            ++i;
        }
        Assert.check((boolean)isUsed);
    }

    public boolean edgePossible() {
        return this.disabledIndex() < 0;
    }

    public int disabledIndex() {
        int i = 0;
        while (i < this.sourceEdges.size()) {
            List<Edge> edges = this.sourceEdges.get(i);
            if (edges != null && edges.isEmpty()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clear() {
        for (List<Edge> edges : this.sourceEdges) {
            if (edges == null) continue;
            edges.clear();
        }
    }
}

