/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.command.adapter;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.command.adapter.CommandProviderAdapter;
import org.eclipse.equinox.console.telnet.TelnetCommand;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private ServiceTracker<CommandProcessor, ServiceTracker<ConsoleSession, CommandSession>> commandProcessorTracker;
    private ServiceTracker<CommandProvider, List<ServiceRegistration<?>>> commandProviderTracker;

    public void start(BundleContext context) throws Exception {
        this.commandProviderTracker = new ServiceTracker(context, CommandProvider.class.getName(), (ServiceTrackerCustomizer)new CommandCustomizer(context));
        this.commandProviderTracker.open();
        this.commandProcessorTracker = new ServiceTracker(context, CommandProcessor.class, (ServiceTrackerCustomizer)new ProcessorCustomizer(context));
        this.commandProcessorTracker.open();
    }

    Method[] getCommandMethods(Object command) {
        Method[] methods;
        ArrayList<Method> names = new ArrayList<Method>();
        Class<?> c = command.getClass();
        Method[] methodArray = methods = c.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] types;
            Method method = methodArray[n2];
            if (method.getName().startsWith("_") && method.getModifiers() == 1 && (types = method.getGenericParameterTypes()).length == 1 && types[0].equals(CommandInterpreter.class)) {
                names.add(method);
            }
            ++n2;
        }
        return names.toArray(new Method[names.size()]);
    }

    Dictionary<String, Object> getAttributes(Method[] commandMethods) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "equinox");
        String[] methodNames = new String[commandMethods.length];
        int i = 0;
        while (i < commandMethods.length) {
            String methodName = commandMethods[i].getName().substring(1);
            if (methodName.equals("bundle")) {
                methodName = "x." + methodName;
            }
            methodNames[i] = methodName;
            ++i;
        }
        ((Dictionary)dict).put("osgi.command.function", methodNames);
        return dict;
    }

    public void stop(BundleContext context) throws Exception {
        this.commandProviderTracker.close();
        this.commandProcessorTracker.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CommandCustomizer
    implements ServiceTrackerCustomizer<CommandProvider, List<ServiceRegistration<?>>> {
        private BundleContext context;

        public CommandCustomizer(BundleContext context) {
            this.context = context;
        }

        public List<ServiceRegistration<?>> addingService(ServiceReference<CommandProvider> reference) {
            if (reference.getProperty("osgi.command.function") != null) {
                return null;
            }
            CommandProvider command = (CommandProvider)this.context.getService(reference);
            try {
                Method[] commandMethods = Activator.this.getCommandMethods(command);
                if (commandMethods.length > 0) {
                    ArrayList registrations = new ArrayList();
                    registrations.add(this.context.registerService(Object.class, (Object)new CommandProviderAdapter(command, commandMethods), Activator.this.getAttributes(commandMethods)));
                    return registrations;
                }
                this.context.ungetService(reference);
                return null;
            }
            catch (Exception exception) {
                this.context.ungetService(reference);
                return null;
            }
        }

        public void modifiedService(ServiceReference<CommandProvider> reference, List<ServiceRegistration<?>> service) {
        }

        public void removedService(ServiceReference<CommandProvider> reference, List<ServiceRegistration<?>> registrations) {
            for (ServiceRegistration<?> serviceRegistration : registrations) {
                serviceRegistration.unregister();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProcessorCustomizer
    implements ServiceTrackerCustomizer<CommandProcessor, ServiceTracker<ConsoleSession, CommandSession>> {
        private final BundleContext context;

        public ProcessorCustomizer(BundleContext context) {
            this.context = context;
        }

        public ServiceTracker<ConsoleSession, CommandSession> addingService(ServiceReference<CommandProcessor> reference) {
            CommandProcessor processor = (CommandProcessor)this.context.getService(reference);
            if (processor == null) {
                return null;
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.command.scope", "equinox");
            ((Dictionary)properties).put("osgi.command.function", "telnet");
            TelnetCommand telnet = new TelnetCommand(processor, this.context);
            String consolePropValue = this.context.getProperty("osgi.console");
            if (consolePropValue != null && !"".equals(consolePropValue)) {
                try {
                    telnet.telnet(new String[]{"start"});
                }
                catch (Exception e) {
                    System.out.println("Cannot start telnet. Reason: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            this.context.registerService(TelnetCommand.class.getName(), (Object)telnet, properties);
            ServiceTracker tracker = new ServiceTracker(this.context, ConsoleSession.class, (ServiceTrackerCustomizer)new SessionCustomizer(this.context, processor));
            tracker.open();
            return tracker;
        }

        public void modifiedService(ServiceReference<CommandProcessor> reference, ServiceTracker<ConsoleSession, CommandSession> service) {
        }

        public void removedService(ServiceReference<CommandProcessor> reference, ServiceTracker<ConsoleSession, CommandSession> tracker) {
            tracker.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionCustomizer
    implements ServiceTrackerCustomizer<ConsoleSession, CommandSession> {
        private final BundleContext context;
        final CommandProcessor processor;

        public SessionCustomizer(BundleContext context, CommandProcessor processor) {
            this.context = context;
            this.processor = processor;
        }

        public CommandSession addingService(ServiceReference<ConsoleSession> reference) {
            final ConsoleSession equinoxSession = (ConsoleSession)this.context.getService(reference);
            if (equinoxSession == null) {
                return null;
            }
            PrintStream output = new PrintStream(equinoxSession.getOutput());
            final CommandSession gogoSession = this.processor.createSession(equinoxSession.getInput(), output, output);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        try {
                            gogoSession.execute((CharSequence)"gosh --login --noshutdown");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            gogoSession.close();
                            equinoxSession.close();
                        }
                    }
                    finally {
                        gogoSession.close();
                        equinoxSession.close();
                    }
                }
            }, "Equinox Console Session").start();
            return null;
        }

        public void modifiedService(ServiceReference<ConsoleSession> reference, CommandSession service) {
        }

        public void removedService(ServiceReference<ConsoleSession> reference, CommandSession session) {
            session.close();
        }
    }
}

