/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.viewsupport;

import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.ContributionsViewPart;
import org.eclipse.equinox.jmx.internal.client.ui.invocationView.InvocationView;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanInfoViewPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ViewUtil {
    public static Composite createSection(String sectionTitle, String description, IManagedForm form, Composite parent, int cols, boolean fillBoth, boolean twistie) {
        FormToolkit toolkit = form.getToolkit();
        int flags = 256;
        if (twistie) {
            flags |= 2;
        }
        if (description != null) {
            flags |= 0x80;
        }
        SectionPart sectionPart = new SectionPart(parent, toolkit, flags);
        sectionPart.initialize(form);
        Section section = sectionPart.getSection();
        section.setText(sectionTitle);
        if (description != null) {
            section.setDescription(description);
        }
        flags = fillBoth ? 1808 : 768;
        section.setLayoutData((Object)new GridData(flags));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(cols, false));
        composite.setLayoutData((Object)new GridData(flags));
        section.setClient((Control)composite);
        if (twistie) {
            section.setEnabled(false);
            section.setExpanded(false);
        }
        return composite;
    }

    public static ContributionsViewPart getContributionsView() {
        return (ContributionsViewPart)ViewUtil.getView("org.eclipse.equinox.jmx.client.ui.contributionsview");
    }

    public static InvocationView getInvocationView() {
        return (InvocationView)ViewUtil.getView("org.eclipse.equinox.jmx.client.ui.invocationView");
    }

    public static MBeanInfoViewPart getBeanInfoView() {
        return (MBeanInfoViewPart)ViewUtil.getView("org.eclipse.equinox.jmx.client.ui.mbeaninfoview");
    }

    private static IViewPart getView(String viewId) {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
    }
}

