/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.preferences.jmx;

import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.preferences.jmx.Activator;
import org.eclipse.equinox.internal.preferences.jmx.KVP;
import org.eclipse.equinox.internal.preferences.jmx.Messages;
import org.eclipse.equinox.jmx.server.Contribution;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceContribution
extends Contribution {
    private static final String IMAGE_PATH = "icons/node.gif";
    private static final String EMPTY_STRING = "";
    private static final String METHOD_ADD_CHILD = "addChild";
    private static final String METHOD_PUT = "put";
    private static final String METHOD_REMOVE_NODE = "removeNode";
    private static final String PARM_NAME = "name";
    private static final String PARM_KEY = "key";
    private static final String PARM_VALUE = "value";
    private static final String TYPE_STRING = "java.lang.String";

    public PreferenceContribution(Preferences delegate) {
        super((Object)delegate.absolutePath());
    }

    protected ObjectName getObjectName() {
        try {
            return new ObjectName("jmxserver:type=Preferences,name=" + this.contributionDelegate);
        }
        catch (Exception exception) {
            return super.getObjectName();
        }
    }

    private Preferences getDeletgate() {
        return Activator.getPreferenceService().getRootNode().node((String)this.contributionDelegate);
    }

    protected String getName() {
        return this.getDeletgate().name();
    }

    protected Object[] getChildren() {
        String[] children = new String[]{};
        try {
            children = this.getDeletgate().childrenNames();
        }
        catch (BackingStoreException backingStoreException) {}
        String[] keys = new String[]{};
        try {
            keys = this.getDeletgate().keys();
        }
        catch (BackingStoreException backingStoreException) {}
        Object[] result = new Object[children.length + keys.length];
        int i = 0;
        while (i < children.length) {
            result[i] = this.getDeletgate().node(children[i]);
            ++i;
        }
        i = children.length;
        while (i < keys.length) {
            result[i] = new KVP(this.getDeletgate(), keys[i], this.getDeletgate().get(keys[i], EMPTY_STRING));
            ++i;
        }
        return result;
    }

    protected Set getProperties() {
        return null;
    }

    protected MBeanInfo getMBeanInfo(Object delegate) {
        return new MBeanInfo(((Object)((Object)this)).getClass().getName(), null, null, null, this.createOperations(), null);
    }

    private MBeanOperationInfo[] createOperations() {
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>();
        result.add(this.createAddChildOperation());
        result.add(this.createRemoveNodeOperation());
        result.add(this.createPutOperation());
        return result.toArray(new MBeanOperationInfo[result.size()]);
    }

    private MBeanOperationInfo createPutOperation() {
        MBeanParameterInfo[] parms = new MBeanParameterInfo[]{new MBeanParameterInfo(PARM_KEY, TYPE_STRING, Messages.parm_key_desc), new MBeanParameterInfo(PARM_VALUE, TYPE_STRING, Messages.parm_value_desc)};
        return new MBeanOperationInfo(METHOD_PUT, Messages.operation_put, parms, Void.TYPE.getName(), 0);
    }

    private MBeanOperationInfo createRemoveNodeOperation() {
        return new MBeanOperationInfo(METHOD_REMOVE_NODE, Messages.operation_removeNode, null, Void.TYPE.getName(), 0);
    }

    private MBeanOperationInfo createAddChildOperation() {
        MBeanParameterInfo[] parms = new MBeanParameterInfo[]{new MBeanParameterInfo(PARM_NAME, TYPE_STRING, Messages.parm_childName_desc)};
        return new MBeanOperationInfo(METHOD_ADD_CHILD, Messages.operation_addChild, parms, Void.TYPE.getName(), 0);
    }

    protected Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        if (METHOD_ADD_CHILD.equals(operationName)) {
            this.handleAddChildOperation(args);
        } else if (METHOD_REMOVE_NODE.equals(operationName)) {
            this.handleRemoveNodeOperation();
        } else if (METHOD_PUT.equals(operationName)) {
            this.handlePutOperation(args);
        }
        return null;
    }

    private void handlePutOperation(Object[] args) {
        if (args == null || args.length != 2) {
            return;
        }
        if (!(args[0] instanceof String) || !(args[1] instanceof String)) {
            return;
        }
        this.getDeletgate().put((String)args[0], (String)args[1]);
    }

    private void handleAddChildOperation(Object[] args) {
        if (args == null || args.length != 1) {
            return;
        }
        if (!(args[0] instanceof String)) {
            return;
        }
        this.getDeletgate().node((String)args[0]);
    }

    private void handleRemoveNodeOperation() {
        try {
            this.getDeletgate().removeNode();
        }
        catch (BackingStoreException e) {
            Activator.log(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Object getAttribute(String attribute) {
        return null;
    }

    public void setAttribute(Attribute attribute) {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    protected URL getImageLocation() {
        return FileLocator.find((Bundle)Activator.getContext().getBundle(), (IPath)new Path(IMAGE_PATH), null);
    }
}

