/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.StructuralFeatureMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;
import org.eclipse.emf.emfstore.modelmutator.ESRandomChangeMode;
import org.eclipse.emf.emfstore.modelmutator.ESReferenceChangeMutation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeMutation
extends StructuralFeatureMutation<ESReferenceChangeMutation>
implements ESReferenceChangeMutation {
    private EObject newReferenceValue;
    private ESRandomChangeMode randomChangeMode;

    public ReferenceChangeMutation(ESModelMutatorUtil util) {
        super(util);
        this.addTargetFeatureReferencePredicate();
    }

    protected ReferenceChangeMutation(ESModelMutatorUtil util, MutationTargetSelector selector) {
        super(util, selector);
        this.addTargetFeatureReferencePredicate();
    }

    private void addTargetFeatureReferencePredicate() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.IS_MUTABLE_REFERENCE);
    }

    @Override
    public Mutation clone() {
        return new ReferenceChangeMutation(this.getUtil(), this.getTargetContainerSelector());
    }

    @Override
    public void apply() throws ESMutationException {
        switch (this.getRandomChangeMode()) {
            case ADD: {
                this.doAddReferenceValue();
                break;
            }
            case DELETE: {
                this.doDeleteReferenceValue();
                break;
            }
            case REORDER: {
                this.doReorderReferenceValue();
                break;
            }
        }
    }

    private boolean doAddReferenceValue() throws ESMutationException {
        this.makeSureChangingTargetDoesNotAffectContainmentReference();
        this.makeSureValueForSelectedFeatureToAddExists();
        this.getTargetContainerSelector().doSelection();
        EObject eObject = this.getTargetContainerSelector().getTargetObject();
        EReference eReference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        EObject newValue = this.selectNewReferenceValue();
        boolean success = newValue != null ? this.addOrSetReferenceValue(eObject, eReference, newValue) : false;
        return success;
    }

    private boolean addOrSetReferenceValue(EObject eObject, EReference eReference, EObject newValue) {
        boolean success;
        if (newValue != null) {
            if (eReference.isMany()) {
                int insertionIndex = this.getTargetContainerSelector().getRandomIndexFromTargetObjectAndFeatureValueRange();
                this.getUtil().addPerCommand(eObject, (EStructuralFeature)eReference, newValue, insertionIndex);
            } else {
                this.getUtil().setPerCommand(eObject, (EStructuralFeature)eReference, newValue);
            }
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    protected EObject selectNewReferenceValue() throws ESMutationException {
        if (this.newReferenceValue != null) {
            return this.newReferenceValue;
        }
        EReference eReference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        Iterable<EObject> suitableEObjects = this.getUtil().getSuitableEObjectsForAvailableFeature((EStructuralFeature)eReference);
        int numberOfAvailableEObjects = Iterables.size(suitableEObjects);
        if (numberOfAvailableEObjects < 1) {
            throw new ESMutationException("No objects available as feature values to add");
        }
        int randomIndex = this.getRandom().nextInt(numberOfAvailableEObjects);
        EObject newReferenceValue = (EObject)Iterables.get(suitableEObjects, (int)randomIndex);
        return newReferenceValue;
    }

    private boolean doDeleteReferenceValue() throws ESMutationException {
        this.makeSureChangingTargetDoesNotAffectContainmentReference();
        this.makeSureWeHaveValuesInSelectedObjectAtSelectedFeature();
        this.getTargetContainerSelector().doSelection();
        EObject eObject = this.getTargetContainerSelector().getTargetObject();
        EReference eReference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        if (eReference.isMany()) {
            List currentValues = (List)eObject.eGet((EStructuralFeature)eReference);
            int numberOfCurrentValues = currentValues.size();
            int deletionIndex = this.getRandom().nextInt(numberOfCurrentValues);
            currentValues.remove(deletionIndex);
            this.getUtil().setPerCommand(eObject, (EStructuralFeature)eReference, currentValues);
        } else {
            this.getUtil().setPerCommand(eObject, (EStructuralFeature)eReference, SetCommand.UNSET_VALUE);
        }
        return true;
    }

    private void makeSureChangingTargetDoesNotAffectContainmentReference() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add((Predicate<? super EStructuralFeature>)Predicates.not(MutationPredicates.IS_CONTAINMENT_OR_OPPOSITE_OF_CONTAINMENT_REFERENCE));
    }

    private void makeSureValueForSelectedFeatureToAddExists() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add((Predicate<? super EStructuralFeature>)new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature input) {
                return input != null && !Iterables.isEmpty(ReferenceChangeMutation.this.getUtil().getSuitableEObjectsForAvailableFeature(input));
            }
        });
    }

    private boolean doReorderReferenceValue() throws ESMutationException {
        boolean success;
        this.makeSureSelectedFeatureIsMultiValued();
        this.makeSureWeHaveValuesInSelectedObjectAtSelectedFeature();
        this.getTargetContainerSelector().doSelection();
        EObject eObject = this.getTargetContainerSelector().getTargetObject();
        EReference eReference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        if (eReference.isMany()) {
            List currentValues = (List)eObject.eGet((EStructuralFeature)eReference);
            int numberOfCurrentValues = currentValues.size();
            int pickIndex = this.getRandom().nextInt(numberOfCurrentValues);
            int putIndex = this.getRandom().nextInt(numberOfCurrentValues);
            this.getUtil().movePerCommand(eObject, (EStructuralFeature)eReference, currentValues.get(pickIndex), putIndex);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    private void makeSureSelectedFeatureIsMultiValued() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.IS_MULTI_VALUED);
    }

    private void makeSureWeHaveValuesInSelectedObjectAtSelectedFeature() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NON_EMPTY_EOBJECT_LIST);
    }

    protected ESRandomChangeMode getRandomChangeMode() {
        if (this.randomChangeMode != null) {
            return this.randomChangeMode;
        }
        ESRandomChangeMode[] values = ESRandomChangeMode.values();
        int nextInt = this.getRandom().nextInt(values.length);
        return values[nextInt];
    }

    @Override
    public ESReferenceChangeMutation setRandomChangeMode(ESRandomChangeMode randomChangeMode) {
        this.randomChangeMode = randomChangeMode;
        return this;
    }

    @Override
    public ESReferenceChangeMutation setNewReferenceValue(EObject newValue) {
        if (newValue != null) {
            this.newReferenceValue = newValue;
        }
        return this;
    }
}

