/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.mocks;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.ShareProjectAdapter;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESAuthenticationInformationImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ESSessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionMock
implements ConnectionManager {
    private final EMFStore emfStore;
    private final HashSet<SessionId> sessions;
    private final AccessControl accessControl;
    private boolean deleteFiles;

    public ConnectionMock(EMFStore emfStore, AccessControl accessControl) {
        this.emfStore = emfStore;
        this.accessControl = accessControl;
        this.sessions = new LinkedHashSet<SessionId>();
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    public AuthenticationInformation logIn(String username, String password, ServerInfo severInfo, ClientVersionInfo clientVersionInfo) throws ESException {
        ESAuthenticationInformation logIn = this.accessControl.getLoginService().logIn(username, password, (ESClientVersionInfo)((ClientVersionInfo)ModelUtil.clone((EObject)clientVersionInfo)).toAPI());
        AuthenticationInformation authInfo = (AuthenticationInformation)((ESAuthenticationInformationImpl)ESAuthenticationInformationImpl.class.cast(logIn)).toInternalAPI();
        this.sessions.add(authInfo.getSessionId());
        return authInfo;
    }

    public void logout(SessionId sessionId) throws ESException {
        this.accessControl.getLoginService().logout((ESSessionId)((SessionId)ModelUtil.clone((EObject)sessionId)).toAPI());
        this.sessions.remove(sessionId);
    }

    public boolean isLoggedIn(SessionId sessionId) {
        return this.sessions.contains(ModelUtil.clone((EObject)sessionId));
    }

    public List<ProjectInfo> getProjectList(SessionId sessionId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getProjectList(clonedSessionId));
    }

    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return (Project)ModelUtil.clone((EObject)this.emfStore.getProject(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (VersionSpec)ModelUtil.clone((EObject)versionSpec)));
    }

    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, AbstractChangePackage changePackage, BranchVersionSpec targetBranch, PrimaryVersionSpec sourceVersion, LogMessage logMessage) throws ESException, InvalidVersionSpecException {
        AbstractChangePackage cp = changePackage;
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        if (FileBasedChangePackage.class.isInstance(changePackage)) {
            cp = ((FileBasedChangePackage)FileBasedChangePackage.class.cast(changePackage)).toInMemoryChangePackage();
        }
        return (PrimaryVersionSpec)ModelUtil.clone((EObject)this.emfStore.createVersion(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (PrimaryVersionSpec)ModelUtil.clone((EObject)baseVersionSpec), (AbstractChangePackage)ModelUtil.clone((EObject)cp), (BranchVersionSpec)ModelUtil.clone((EObject)targetBranch), (PrimaryVersionSpec)ModelUtil.clone((EObject)sourceVersion), (LogMessage)ModelUtil.clone((EObject)logMessage)));
    }

    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return (PrimaryVersionSpec)ModelUtil.clone((EObject)this.emfStore.resolveVersionSpec(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (VersionSpec)ModelUtil.clone((EObject)versionSpec)));
    }

    public List<AbstractChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        List changes = this.emfStore.getChanges(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (VersionSpec)ModelUtil.clone((EObject)source), (VersionSpec)ModelUtil.clone((EObject)target));
        return ModelUtil.clone((List)changes);
    }

    public List<BranchInfo> getBranches(SessionId sessionId, ProjectId projectId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getBranches(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery<?> historyQuery) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getHistoryInfo(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (HistoryQuery)ModelUtil.clone(historyQuery)));
    }

    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        this.emfStore.addTag(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (PrimaryVersionSpec)ModelUtil.clone((EObject)versionSpec), (TagVersionSpec)ModelUtil.clone((EObject)tag));
    }

    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        this.emfStore.removeTag(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (PrimaryVersionSpec)ModelUtil.clone((EObject)versionSpec), (TagVersionSpec)ModelUtil.clone((EObject)tag));
    }

    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        ProjectInfo projectInfo = this.emfStore.createEmptyProject(clonedSessionId, name, description, (LogMessage)ModelUtil.clone((EObject)logMessage));
        ESSessionId resolvedSession = this.accessControl.getSessions().resolveSessionById(clonedSessionId.getId());
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        ShareProjectAdapter.attachTo((SessionId)session, (ProjectId)projectInfo.getProjectId());
        return projectInfo;
    }

    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws ESException {
        SessionId clonedSessionId = (SessionId)ModelUtil.clone((EObject)sessionId);
        this.checkSessionId(clonedSessionId);
        ProjectInfo projectInfo = this.emfStore.createProject(clonedSessionId, name, description, (LogMessage)ModelUtil.clone((EObject)logMessage), (Project)ModelUtil.clone((EObject)project));
        ESSessionId resolvedSession = this.accessControl.getSessions().resolveSessionById(clonedSessionId.getId());
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        ShareProjectAdapter.attachTo((SessionId)session, (ProjectId)projectInfo.getProjectId());
        return projectInfo;
    }

    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        this.deleteFiles = deleteFiles;
        this.emfStore.deleteProject(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), deleteFiles);
    }

    public boolean didDeleteFiles() {
        return this.deleteFiles;
    }

    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return (ACUser)ModelUtil.clone((EObject)this.emfStore.resolveUser(clonedSessionId, (ACOrgUnitId)ModelUtil.clone((EObject)id)));
    }

    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return (ProjectId)ModelUtil.clone((EObject)this.emfStore.importProjectHistoryToServer(clonedSessionId, (ProjectHistory)ModelUtil.clone((EObject)projectHistory)));
    }

    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return (ProjectHistory)ModelUtil.clone((EObject)this.emfStore.exportProjectHistoryFromServer(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return this.emfStore.uploadFileChunk(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), fileChunk);
    }

    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return this.emfStore.downloadFileChunk(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), fileInformation);
    }

    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser user, ProjectId projectId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        this.emfStore.transmitProperty(clonedSessionId, (OrgUnitProperty)ModelUtil.clone((EObject)changedProperty), (ACUser)ModelUtil.clone((EObject)user), (ProjectId)ModelUtil.clone((EObject)projectId));
    }

    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> property, ProjectId projectId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.setEMFProperties(clonedSessionId, ModelUtil.clone(property), (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getEMFProperties(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public void registerEPackage(SessionId sessionId, EPackage pkg) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        this.emfStore.registerEPackage(clonedSessionId, (EPackage)ModelUtil.clone((EObject)pkg));
    }

    public String getVersion(SessionId sessionId) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return this.emfStore.getVersion(clonedSessionId);
    }

    public String getVersion(ServerInfo serverInfo) throws ESException {
        SessionId sessionId = ModelFactory.eINSTANCE.createSessionId();
        sessionId.setId(String.valueOf(serverInfo.getUrl().toString()) + "/defaultSession");
        this.sessions.add(sessionId);
        return this.emfStore.getVersion(sessionId);
    }

    public String uploadChangePackageFragment(SessionId sessionId, ProjectId projectId, ChangePackageEnvelope envelope) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return this.emfStore.uploadChangePackageFragment(clonedSessionId, (ProjectId)ModelUtil.clone((EObject)projectId), (ChangePackageEnvelope)ModelUtil.clone((EObject)envelope));
    }

    public ChangePackageEnvelope downloadChangePackageFragment(SessionId sessionId, ProjectId projectId, String proxyId, int fragmentIndex) throws ESException {
        SessionId clonedSessionId = this.checkSessionId(sessionId);
        return (ChangePackageEnvelope)ModelUtil.clone((EObject)this.emfStore.downloadChangePackageFragment(clonedSessionId, projectId, proxyId, fragmentIndex));
    }

    private SessionId checkSessionId(SessionId sessionId) throws ESException {
        SessionId clonedSessionId = (SessionId)ModelUtil.clone((EObject)sessionId);
        if (!this.isLoggedIn(clonedSessionId)) {
            throw new AccessControlException();
        }
        return clonedSessionId;
    }
}

