/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.transaction;

import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;
import org.eclipse.emf.transaction.internal.Tracing;

public abstract class AbstractEMFStoreTransactionalCommandStackImpl
extends TransactionalCommandStackImpl {
    private static final String REDO_METHOD_NAME = "redo";
    private static final String UNDO_METHOD_NAME = "undo";

    public void undo() {
        if (this.canUndo()) {
            try {
                EMFCommandTransaction tx = this.createTransaction(this.getUndoCommand(), this.getUndoRedoOptions());
                this.basicUndo();
                tx.commit();
            }
            catch (RuntimeException e) {
                this.logAndRollback(e, UNDO_METHOD_NAME);
            }
            catch (RollbackException ex) {
                this.logAndRollback((Exception)((Object)ex), UNDO_METHOD_NAME);
            }
            catch (InterruptedException ex) {
                this.logAndRollback(ex, UNDO_METHOD_NAME);
            }
        }
    }

    public void redo() {
        if (this.canRedo()) {
            try {
                EMFCommandTransaction tx = this.createTransaction(this.getRedoCommand(), this.getUndoRedoOptions());
                this.basicRedo();
                tx.commit();
            }
            catch (RuntimeException e) {
                this.logAndRollback(e, REDO_METHOD_NAME);
            }
            catch (RollbackException ex) {
                this.logAndRollback((Exception)((Object)ex), REDO_METHOD_NAME);
            }
            catch (InterruptedException ex) {
                this.logAndRollback(ex, REDO_METHOD_NAME);
            }
        }
    }

    private void logAndRollback(Exception e, String methodName) {
        Tracing.catching(TransactionalCommandStackImpl.class, (String)methodName, (Throwable)e);
        this.handleError(e);
    }

    protected abstract void basicUndo();

    protected abstract void basicRedo();
}

