/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangePackageUtil {
    private ChangePackageUtil() {
    }

    public static AbstractChangePackage createChangePackage(boolean useInMemoryChangePackage) {
        if (useInMemoryChangePackage) {
            return VersioningFactory.eINSTANCE.createChangePackage();
        }
        FileBasedChangePackage fileBasedChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        fileBasedChangePackage.initialize(FileUtil.createLocationForTemporaryChangePackage());
        return fileBasedChangePackage;
    }

    public static Iterator<ChangePackageEnvelope> splitChangePackage(final AbstractChangePackage changePackage, final int changePackageFragmentSize) {
        return new Iterator<ChangePackageEnvelope>(){
            private int fragmentIndex;
            private int currentOpIndex;
            private int count;
            private boolean isInitialized;
            private ChangePackageEnvelope envelope;

            private void init() {
                int leafSizeCounter = 0;
                ESCloseableIterable<AbstractOperation> operations = changePackage.operations();
                try {
                    for (AbstractOperation operation : operations.iterable()) {
                        int countLeafOperations = ChangePackageUtil.countLeafOperations(operation);
                        if ((leafSizeCounter += countLeafOperations) < changePackageFragmentSize) continue;
                        leafSizeCounter = 0;
                        ++this.count;
                    }
                }
                finally {
                    operations.close();
                }
                if (leafSizeCounter != 0 || this.count == 0) {
                    ++this.count;
                }
                this.isInitialized = true;
            }

            @Override
            public boolean hasNext() {
                if (!this.isInitialized) {
                    this.init();
                }
                if (this.envelope == null) {
                    this.envelope = VersioningFactory.eINSTANCE.createChangePackageEnvelope();
                    ChangePackage cp = VersioningFactory.eINSTANCE.createChangePackage();
                    cp.setLogMessage((LogMessage)ModelUtil.clone((EObject)changePackage.getLogMessage()));
                    this.envelope.setFragmentCount(this.count);
                }
                while (ChangePackageUtil.countLeafOperations(this.envelope.getFragment()) < changePackageFragmentSize && this.currentOpIndex < changePackage.size()) {
                    AbstractOperation op = changePackage.get(this.currentOpIndex);
                    this.envelope.getFragment().add((Object)((AbstractOperation)ModelUtil.clone((EObject)op)));
                    ++this.currentOpIndex;
                }
                this.envelope.setFragmentIndex(this.fragmentIndex);
                return !this.envelope.getFragment().isEmpty() || this.fragmentIndex == 0;
            }

            @Override
            public ChangePackageEnvelope next() {
                boolean hasNext;
                if (this.envelope == null && !(hasNext = this.hasNext())) {
                    throw new NoSuchElementException();
                }
                ChangePackageEnvelope ret = this.envelope;
                this.envelope = null;
                ++this.fragmentIndex;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int countLeafOperations(Collection<AbstractOperation> operations) {
        int ret = 0;
        for (AbstractOperation operation : operations) {
            if (operation instanceof CompositeOperation) {
                ret += ChangePackageUtil.getSize((CompositeOperation)operation);
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public static int countLeafOperations(AbstractOperation operation) {
        return ChangePackageUtil.countLeafOperations(Collections.singleton(operation));
    }

    public static int countLeafOperations(List<AbstractChangePackage> changePackages) {
        int count = 0;
        for (AbstractChangePackage changePackage : changePackages) {
            ESCloseableIterable<AbstractOperation> operations = changePackage.operations();
            try {
                for (AbstractOperation operation : operations.iterable()) {
                    count += ChangePackageUtil.countLeafOperations(operation);
                }
            }
            finally {
                operations.close();
            }
        }
        return count;
    }

    public static int countOperations(List<AbstractChangePackage> changePackages) {
        int count = 0;
        for (AbstractChangePackage changePackage : changePackages) {
            count += changePackage.size();
        }
        return count;
    }

    private static int getSize(CompositeOperation compositeOperation) {
        int ret = 0;
        EList<AbstractOperation> subOperations = compositeOperation.getSubOperations();
        for (AbstractOperation abstractOperation : subOperations) {
            if (abstractOperation instanceof CompositeOperation) {
                ret += ChangePackageUtil.getSize((CompositeOperation)abstractOperation);
                continue;
            }
            ++ret;
        }
        return ret;
    }
}

