/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.CancelOperationException;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIUpdateProjectController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.BranchSelectionDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.CommitDialog;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.exceptions.ESUpdateRequiredException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.ESLogMessage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICreateBranchController
extends AbstractEMFStoreUIController<ESPrimaryVersionSpec>
implements ESCommitCallback {
    private final ProjectSpace projectSpace;
    private int dialogReturnValue;
    private BranchVersionSpec branch;

    public UICreateBranchController(Shell shell, ESLocalProject projectSpace) {
        this(shell, projectSpace, null);
    }

    public UICreateBranchController(Shell shell, ESLocalProject localProject, BranchVersionSpec branch) {
        super(shell, true, true);
        this.projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
        this.branch = branch;
    }

    public void noLocalChanges(ESLocalProject projectSpace) {
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MessageDialog.openInformation((Shell)UICreateBranchController.this.getShell(), null, (String)Messages.UICreateBranchController_NoLocalChanges);
                return null;
            }
        });
    }

    public boolean baseVersionOutOfDate(final ESLocalProject projectSpace, final IProgressMonitor progressMonitor) {
        final String message = Messages.UICreateBranchController_ProjectOutdated;
        return RunInUI.runWithResult(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean shouldUpdate = MessageDialog.openConfirm((Shell)UICreateBranchController.this.getShell(), (String)Messages.UICreateBranchController_Confirmation, (String)message);
                if (shouldUpdate) {
                    ESPrimaryVersionSpec baseVersion = (ESPrimaryVersionSpec)UICreateBranchController.this.projectSpace.getBaseVersion().toAPI();
                    ESPrimaryVersionSpec version = (ESPrimaryVersionSpec)new UIUpdateProjectController(UICreateBranchController.this.getShell(), projectSpace).executeSub(progressMonitor);
                    if (version.equals(baseVersion)) {
                        return false;
                    }
                }
                return shouldUpdate;
            }
        });
    }

    public boolean inspectChanges(ESLocalProject localProject, final ESChangePackage changePackage, ESModelElementIdToEObjectMapping idToEObjectMapping) {
        ESChangePackageImpl internalChangePackage = (ESChangePackageImpl)changePackage;
        ESLocalProjectImpl localProjectImpl = (ESLocalProjectImpl)localProject;
        final CommitDialog commitDialog = new CommitDialog(this.getShell(), (ChangePackage)internalChangePackage.toInternalAPI(), (ProjectSpace)localProjectImpl.toInternalAPI(), (ModelElementIdToEObjectMapping)((ESModelElementIdToEObjectMappingImpl)idToEObjectMapping).toInternalAPI());
        this.dialogReturnValue = RunInUI.runWithResult(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return commitDialog.open();
            }
        });
        if (this.dialogReturnValue == 0) {
            RunESCommand.run((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LogMessage logMessage = VersioningFactory.eINSTANCE.createLogMessage();
                    logMessage.setAuthor(UICreateBranchController.this.projectSpace.getUsersession().getUsername());
                    logMessage.setClientDate(new Date());
                    logMessage.setMessage(commitDialog.getLogText());
                    changePackage.setLogMessage((ESLogMessage)logMessage.toAPI());
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public ESPrimaryVersionSpec doRun(IProgressMonitor progressMonitor) throws ESException {
        try {
            if (this.branch == null) {
                this.branch = this.branchSelection(this.projectSpace);
            }
            PrimaryVersionSpec commitToBranch = this.projectSpace.commitToBranch(this.branch, null, (ESCommitCallback)this, progressMonitor);
            return (ESPrimaryVersionSpec)commitToBranch.toAPI();
        }
        catch (ESUpdateRequiredException eSUpdateRequiredException) {
        }
        catch (ESException e) {
            if (e instanceof CancelOperationException) {
                return null;
            }
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openError((Shell)UICreateBranchController.this.getShell(), (String)Messages.UICreateBranchController_CreateBranch_Title, (String)MessageFormat.format(Messages.UICreateBranchController_CreateBranch_Message, e.getMessage()));
                    return null;
                }
            });
        }
        return null;
    }

    private BranchVersionSpec branchSelection(ProjectSpace projectSpace) throws ESException {
        final List branches = projectSpace.getBranches();
        String branch = RunInUI.WithException.runWithResult(new Callable<String>(){

            @Override
            public String call() throws Exception {
                BranchSelectionDialog.Creation dialog = new BranchSelectionDialog.Creation(UICreateBranchController.this.getShell(), branches);
                dialog.setBlockOnOpen(true);
                if (dialog.open() != 0 || dialog.getNewBranch() == null || dialog.getNewBranch().equals("")) {
                    throw new CancelOperationException(Messages.UICreateBranchController_NoBranchSpecified);
                }
                return dialog.getNewBranch();
            }
        });
        return Versions.createBRANCH((String)branch);
    }
}

