/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;

public class SimplePropertyFileVerifier
extends AbstractAuthenticationControl {
    private final Properties passwordFile;
    private final Hash hash;
    private final String filePath;

    public SimplePropertyFileVerifier(String filePath) throws FatalESException {
        this(filePath, Hash.NONE);
    }

    public SimplePropertyFileVerifier(String filePath, Hash hash) throws FatalESException {
        this.filePath = filePath;
        if (hash == null) {
            throw new FatalESException(Messages.SimplePropertyFileVerifier_HashMayNotBeNull);
        }
        this.hash = hash;
        this.passwordFile = new Properties();
        this.loadPasswordFile(filePath);
    }

    private void loadPasswordFile(String filePath) {
        block14: {
            File propertyFile = new File(filePath);
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(propertyFile);
                    this.passwordFile.load(fis);
                }
                catch (IOException iOException) {
                    ModelUtil.logInfo((String)(String.valueOf(Messages.SimplePropertyFileVerifier_CouldNotLoadPasswordFile) + filePath));
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException2) {
                            ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    ModelUtil.logInfo((String)("Couldn't load password file from path: " + filePath));
                }
            }
        }
    }

    protected boolean verifyPassword(ACUser resolvedUser, String username, String password) throws AccessControlException {
        this.loadPasswordFile(this.filePath);
        String expectedPassword = this.passwordFile.getProperty(username);
        password = this.hashPassword(password);
        return expectedPassword != null && expectedPassword.equals(password);
    }

    private String hashPassword(String password) {
        if (password == null || this.hash.equals((Object)Hash.NONE)) {
            return password;
        }
        try {
            MessageDigest md = null;
            switch (this.hash) {
                case SHA1: {
                    md = MessageDigest.getInstance("SHA-1");
                    break;
                }
                case MD5: {
                    md = MessageDigest.getInstance("MD5");
                }
            }
            if (md != null) {
                return new String(md.digest(password.getBytes()));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hash {
        NONE,
        MD5,
        SHA1;

    }
}

