/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.mocks;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.ShareProjectAdapter;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionMock
implements ConnectionManager {
    private final EMFStore emfStore;
    private final HashSet<SessionId> sessions;
    private final AccessControl accessControl;
    private boolean deleteFiles;

    public ConnectionMock(EMFStore emfStore, AccessControl accessControl) {
        this.emfStore = emfStore;
        this.accessControl = accessControl;
        this.sessions = new LinkedHashSet<SessionId>();
    }

    public AuthenticationInformation logIn(String username, String password, ServerInfo severInfo, ClientVersionInfo clientVersionInfo) throws ESException {
        AuthenticationInformation logIn = this.accessControl.logIn(username, password, clientVersionInfo);
        this.sessions.add(logIn.getSessionId());
        return logIn;
    }

    public void logout(SessionId sessionId) throws ESException {
        this.accessControl.logout(sessionId);
        this.sessions.remove(sessionId);
    }

    public boolean isLoggedIn(SessionId id) {
        return this.sessions.contains(id);
    }

    public void checkSessionId(SessionId sessionId) throws ESException {
        if (!this.isLoggedIn(sessionId)) {
            throw new AccessControlException();
        }
    }

    public List<ProjectInfo> getProjectList(SessionId sessionId) throws ESException {
        this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getProjectList((SessionId)ModelUtil.clone((EObject)sessionId)));
    }

    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws ESException {
        this.checkSessionId(sessionId);
        return (Project)ModelUtil.clone((EObject)this.emfStore.getProject((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (VersionSpec)ModelUtil.clone((EObject)versionSpec)));
    }

    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, ChangePackage changePackage, BranchVersionSpec targetBranch, PrimaryVersionSpec sourceVersion, LogMessage logMessage) throws ESException, InvalidVersionSpecException {
        this.checkSessionId(sessionId);
        return (PrimaryVersionSpec)ModelUtil.clone((EObject)this.emfStore.createVersion((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (PrimaryVersionSpec)ModelUtil.clone((EObject)baseVersionSpec), (ChangePackage)ModelUtil.clone((EObject)changePackage), (BranchVersionSpec)ModelUtil.clone((EObject)targetBranch), (PrimaryVersionSpec)ModelUtil.clone((EObject)sourceVersion), (LogMessage)ModelUtil.clone((EObject)logMessage)));
    }

    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws ESException {
        this.checkSessionId(sessionId);
        return (PrimaryVersionSpec)ModelUtil.clone((EObject)this.emfStore.resolveVersionSpec((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (VersionSpec)ModelUtil.clone((EObject)versionSpec)));
    }

    public List<ChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws ESException {
        this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getChanges((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (VersionSpec)ModelUtil.clone((EObject)source), (VersionSpec)ModelUtil.clone((EObject)target)));
    }

    public List<BranchInfo> getBranches(SessionId sessionId, ProjectId projectId) throws ESException {
        this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getBranches((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery<?> historyQuery) throws ESException {
        this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getHistoryInfo((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (HistoryQuery)ModelUtil.clone(historyQuery)));
    }

    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        this.checkSessionId(sessionId);
        this.emfStore.addTag((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (PrimaryVersionSpec)ModelUtil.clone((EObject)versionSpec), (TagVersionSpec)ModelUtil.clone((EObject)tag));
    }

    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        this.checkSessionId(sessionId);
        this.emfStore.removeTag((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), (PrimaryVersionSpec)ModelUtil.clone((EObject)versionSpec), (TagVersionSpec)ModelUtil.clone((EObject)tag));
    }

    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws ESException {
        this.checkSessionId(sessionId);
        ProjectInfo projectInfo = this.emfStore.createEmptyProject((SessionId)ModelUtil.clone((EObject)sessionId), name, description, (LogMessage)ModelUtil.clone((EObject)logMessage));
        ShareProjectAdapter.attachTo((SessionId)sessionId, (ProjectId)projectInfo.getProjectId());
        return projectInfo;
    }

    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws ESException {
        this.checkSessionId(sessionId);
        ProjectInfo projectInfo = this.emfStore.createProject((SessionId)ModelUtil.clone((EObject)sessionId), name, description, (LogMessage)ModelUtil.clone((EObject)logMessage), (Project)ModelUtil.clone((EObject)project));
        ShareProjectAdapter.attachTo((SessionId)sessionId, (ProjectId)projectInfo.getProjectId());
        return projectInfo;
    }

    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws ESException {
        this.checkSessionId(sessionId);
        this.deleteFiles = deleteFiles;
        this.emfStore.deleteProject((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), deleteFiles);
    }

    public boolean didDeleteFiles() {
        return this.deleteFiles;
    }

    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws ESException {
        this.checkSessionId(sessionId);
        return (ACUser)ModelUtil.clone((EObject)this.emfStore.resolveUser((SessionId)ModelUtil.clone((EObject)sessionId), (ACOrgUnitId)ModelUtil.clone((EObject)id)));
    }

    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws ESException {
        this.checkSessionId(sessionId);
        return (ProjectId)ModelUtil.clone((EObject)this.emfStore.importProjectHistoryToServer((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectHistory)ModelUtil.clone((EObject)projectHistory)));
    }

    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws ESException {
        this.checkSessionId(sessionId);
        return (ProjectHistory)ModelUtil.clone((EObject)this.emfStore.exportProjectHistoryFromServer((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws ESException {
        this.checkSessionId(sessionId);
        return this.emfStore.uploadFileChunk((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), fileChunk);
    }

    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws ESException {
        this.checkSessionId(sessionId);
        return this.emfStore.downloadFileChunk((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId), fileInformation);
    }

    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser user, ProjectId projectId) throws ESException {
        this.checkSessionId(sessionId);
        this.emfStore.transmitProperty((SessionId)ModelUtil.clone((EObject)sessionId), (OrgUnitProperty)ModelUtil.clone((EObject)changedProperty), (ACUser)ModelUtil.clone((EObject)user), (ProjectId)ModelUtil.clone((EObject)projectId));
    }

    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> property, ProjectId projectId) throws ESException {
        this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.setEMFProperties((SessionId)ModelUtil.clone((EObject)sessionId), ModelUtil.clone(property), (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws ESException {
        this.checkSessionId(sessionId);
        return ModelUtil.clone((List)this.emfStore.getEMFProperties((SessionId)ModelUtil.clone((EObject)sessionId), (ProjectId)ModelUtil.clone((EObject)projectId)));
    }

    public void registerEPackage(SessionId sessionId, EPackage pkg) throws ESException {
        this.checkSessionId(sessionId);
        this.emfStore.registerEPackage((SessionId)ModelUtil.clone((EObject)sessionId), (EPackage)ModelUtil.clone((EObject)pkg));
    }

    public String getVersion(SessionId sessionId) throws ESException {
        return this.emfStore.getVersion(sessionId);
    }

    public String getVersion(ServerInfo serverInfo) throws ESException {
        SessionId sessionId = ModelFactory.eINSTANCE.createSessionId();
        sessionId.setId(String.valueOf(serverInfo.getUrl().toString()) + "/defaultSession");
        this.sessions.add(sessionId);
        return this.emfStore.getVersion(sessionId);
    }
}

