/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.cases;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.client.test.common.dsl.Delete;
import org.eclipse.emf.emfstore.client.test.common.util.ProjectUtil;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecording;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithResult;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationsCanonizer;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ESTest {
    private static final String CLONED_PROJECT_NAME = "clonedProject";
    private ProjectSpace projectSpace;

    public <T extends AbstractOperation> T checkAndCast(AbstractOperation op, Class<T> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(op));
        return (T)((AbstractOperation)clazz.cast(op));
    }

    public ProjectSpace cloneProjectSpace(final ProjectSpace projectSpace) {
        return (ProjectSpace)new EMFStoreCommandWithResult<ProjectSpace>(){

            protected ProjectSpace doRun() {
                WorkspaceBase workspace = (WorkspaceBase)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI();
                return workspace.cloneProject(ESTest.CLONED_PROJECT_NAME, projectSpace.getProject());
            }
        }.run(false);
    }

    @Before
    public void before() {
        try {
            Delete.allLocalProjects();
        }
        catch (IOException ex) {
            Assert.fail((String)ex.getMessage());
        }
        catch (ESException ex) {
            Assert.fail((String)ex.getMessage());
        }
        CommonUtil.setTesting((boolean)true);
        this.projectSpace = (ProjectSpace)((ESLocalProjectImpl)ESLocalProjectImpl.class.cast(Create.project(ProjectUtil.defaultName()))).toInternalAPI();
    }

    @After
    public void after() {
        try {
            Delete.allLocalProjects();
        }
        catch (IOException iOException) {
        }
        catch (ESException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    protected AbstractOperation checkAndGetOperation(Class<? extends AbstractOperation> clazz) {
        Assert.assertEquals((long)1L, (long)this.getProjectSpace().getOperations().size());
        Assert.assertTrue((boolean)clazz.isInstance(this.getProjectSpace().getOperations().get(0)));
        AbstractOperation operation = (AbstractOperation)this.getProjectSpace().getOperations().get(0);
        this.clearOperations();
        Assert.assertEquals((long)this.getProjectSpace().getOperations().size(), (long)0L);
        return operation;
    }

    public ProjectSpace getProjectSpace() {
        return this.projectSpace;
    }

    public ESLocalProject getLocalProject() {
        return (ESLocalProject)this.projectSpace.toAPI();
    }

    public Project getProject() {
        return this.projectSpace.getProject();
    }

    public void clearOperations() {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ESTest.this.getProjectSpace().getOperationManager().clearOperations();
                ESTest.this.getProjectSpace().getOperations().clear();
                return null;
            }
        });
    }

    public NotificationRecording getRecording() {
        return ((ProjectSpaceImpl)this.getProjectSpace()).getNotificationRecorder().getRecording();
    }

    public void canonize(final List<AbstractOperation> operations) {
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                OperationsCanonizer.canonize((List)operations);
            }
        });
    }
}

