/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.wizard.AcUserImportAction;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTabContent
extends TabContent
implements IPropertyChangeListener {
    private static final String DELETE_ICON = "icons/delete.gif";
    private static final String LOCK_ICON = "icons/lock.png";
    private static final String USER_ICON = "icons/user.png";
    private static final String NEW_USER_NAME = "New User";

    public UserTabContent(String string, AdminBroker adminBroker, PropertiesForm frm) {
        super(string, adminBroker, frm);
        this.setTab(this);
    }

    @Override
    protected List<Action> initActions() {
        Action createNewUser = new Action(Messages.UserTabContent_Create_New_User){

            public void run() {
                try {
                    if (UserTabContent.this.userExists(UserTabContent.NEW_USER_NAME)) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UserTabContent_User_Exists, (String)(String.valueOf(Messages.UserTabContent_User_With_Given_Name) + "'" + UserTabContent.NEW_USER_NAME + "'" + Messages.UserTabContent_Already_Exists));
                    } else {
                        UserTabContent.this.getAdminBroker().createUser(UserTabContent.NEW_USER_NAME);
                    }
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                UserTabContent.this.getTableViewer().refresh();
                UserTabContent.this.getForm().getTableViewer().refresh();
            }
        };
        createNewUser.setImageDescriptor(Activator.getImageDescriptor(USER_ICON));
        createNewUser.setToolTipText(Messages.UserTabContent_Create_New_User);
        DeleteUserAction deleteUser = new DeleteUserAction(Messages.UserTabContent_Delete_User);
        deleteUser.setImageDescriptor(Activator.getImageDescriptor(DELETE_ICON));
        deleteUser.setToolTipText(Messages.UserTabContent_Delete_User);
        AcUserImportAction importOrgUnit = new AcUserImportAction(this.getAdminBroker());
        importOrgUnit.addPropertyChangeListener(this);
        ChangePasswordAction changePassword = new ChangePasswordAction(Messages.UserTabContent_Change_Password);
        changePassword.setImageDescriptor(Activator.getImageDescriptor(LOCK_ICON));
        changePassword.setToolTipText(Messages.UserTabContent_Change_Password);
        return Arrays.asList(new Action[]{createNewUser, deleteUser, importOrgUnit, changePassword});
    }

    @Override
    public ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Activator.getImageDescriptor(UserTabContent.USER_ICON).createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ACUser)element).getName();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean userExists(String username) {
        try {
            ACUser user;
            Iterator iterator = this.getAdminBroker().getUsers().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(user = (ACUser)iterator.next()).getName().equals(username));
            return true;
        }
        catch (ESException eSException) {
            return false;
        }
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList users = new ArrayList();
                try {
                    users.addAll(UserTabContent.this.getAdminBroker().getUsers());
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.UserTabContent_Insufficient_Access_Rights, (String)Messages.UserTabContent_Not_Allowed_To_List_Users);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
                return users.toArray(new ACUser[users.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getTableViewer().refresh();
    }

    private final class ChangePasswordAction
    extends Action {
        private ChangePasswordAction(String text) {
            super(text);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)UserTabContent.this.getTableViewer().getSelection();
            for (ACUser user : selection) {
                if (user == null) {
                    return;
                }
                Display display = Display.getCurrent();
                Shell activeShell = display.getActiveShell();
                InputDialog inputDialog = new InputDialog(activeShell, String.valueOf(Messages.UserTabContent_Enter_New_Password_For_User) + "'" + user.getName() + "'", Messages.UserTabContent_Enter_New_Password, "", null);
                if (inputDialog.open() == 0) {
                    String newPassword = inputDialog.getValue();
                    try {
                        UserTabContent.this.getAdminBroker().changeUser(user.getId(), user.getName(), newPassword);
                    }
                    catch (AccessControlException accessControlException) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.UserTabContent_Insufficient_Access_Rights, (String)Messages.UserTabContent_Not_Allowed_To_Change_Password);
                    }
                    catch (ESException ex) {
                        EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                    }
                }
                if (!(UserTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !UserTabContent.this.getForm().getCurrentInput().equals(user)) continue;
                UserTabContent.this.getForm().setInput(null);
            }
            UserTabContent.this.getTableViewer().refresh();
        }
    }

    private final class DeleteUserAction
    extends Action {
        private DeleteUserAction(String text) {
            super(text);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)UserTabContent.this.getTableViewer().getSelection();
            for (ACUser ou : selection) {
                if (ou == null) {
                    return;
                }
                String superUser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
                boolean isAdmin = false;
                for (Role userRole : ou.getRoles()) {
                    if (ou.getName().compareTo(superUser) != 0 || !(userRole instanceof ServerAdmin)) continue;
                    isAdmin = true;
                    break;
                }
                Display display = Display.getCurrent();
                if (isAdmin) {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.UserTabContent_Illegal_Deletion_Attempt, (String)Messages.UserTabContent_Not_Allowed_To_Delete_SuperUser);
                } else {
                    try {
                        UserTabContent.this.getAdminBroker().deleteUser(ou.getId());
                    }
                    catch (AccessControlException accessControlException) {
                        MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.UserTabContent_Insufficient_Access_Rights, (String)Messages.UserTabContent_Not_Allowed_To_Delete_User);
                    }
                    catch (ESException ex) {
                        EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                    }
                }
                if (!(UserTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !UserTabContent.this.getForm().getCurrentInput().equals(ou)) continue;
                UserTabContent.this.getForm().setInput(null);
            }
            UserTabContent.this.getTableViewer().refresh();
        }
    }
}

