/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.wizard.AcUserImportAction;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTabContent
extends TabContent
implements IPropertyChangeListener {
    private static final String NEW_GROUP_NAME = "New Group";
    private static final String GROUP_ICON = "icons/Group.gif";
    private static final String DELETE_ICON = "icons/delete.gif";

    public GroupTabContent(String string, AdminBroker adminBroker, PropertiesForm form) {
        super(string, adminBroker, form);
        this.setTab(this);
    }

    @Override
    protected List<Action> initActions() {
        Action createNewGroup = new Action(Messages.GroupTabContent_Create_New_Group){

            public void run() {
                try {
                    if (GroupTabContent.this.groupExists(GroupTabContent.NEW_GROUP_NAME)) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GroupTabContent_GroupAlreadyExists_Title, (String)NLS.bind((String)Messages.GroupTabContent_GroupAlreadExists, (Object)"'New Group'"));
                    } else {
                        GroupTabContent.this.getAdminBroker().createGroup(GroupTabContent.NEW_GROUP_NAME);
                    }
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.GroupTabContent_Insufficient_Access_Rights, (String)Messages.GroupTabContent_Not_Allowed_To_Create_New_Group);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog(Display.getDefault().getActiveShell(), Messages.GroupTabContent_Error, (Exception)((Object)ex));
                }
                GroupTabContent.this.getTableViewer().refresh();
                GroupTabContent.this.getForm().getTableViewer().refresh();
            }
        };
        createNewGroup.setImageDescriptor(Activator.getImageDescriptor(GROUP_ICON));
        createNewGroup.setToolTipText(Messages.GroupTabContent_Create_New_Group);
        Action deleteGroup = new Action(Messages.GroupTabContent_Delete_Group){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)GroupTabContent.this.getTableViewer().getSelection();
                for (ACGroup ou : selection) {
                    if (ou == null) {
                        return;
                    }
                    try {
                        GroupTabContent.this.getAdminBroker().deleteGroup(ou.getId());
                    }
                    catch (ESException eSException) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupTabContent_Insufficient_Access_Rights, (String)Messages.GroupTabContent_Not_Allowed_To_Delete_Selected_Group);
                    }
                    if (!(GroupTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !GroupTabContent.this.getForm().getCurrentInput().equals(ou)) continue;
                    GroupTabContent.this.getForm().setInput(null);
                }
                GroupTabContent.this.getTableViewer().refresh();
            }
        };
        deleteGroup.setImageDescriptor(Activator.getImageDescriptor(DELETE_ICON));
        deleteGroup.setToolTipText(Messages.GroupTabContent_Delete_Group);
        AcUserImportAction importOrgUnit = new AcUserImportAction(this.getAdminBroker());
        importOrgUnit.addPropertyChangeListener(this);
        return Arrays.asList(new Action[]{createNewGroup, deleteGroup, importOrgUnit});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean groupExists(String groupName) {
        try {
            ACGroup group;
            Iterator iterator = this.getAdminBroker().getGroups().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(group = (ACGroup)iterator.next()).getName().equals(groupName));
            return true;
        }
        catch (ESException eSException) {
            return false;
        }
    }

    @Override
    public ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Activator.getImageDescriptor(GroupTabContent.GROUP_ICON).createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ACGroup)element).getName();
            }
        };
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList groups = new ArrayList();
                try {
                    groups.addAll(GroupTabContent.this.getAdminBroker().getGroups());
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupTabContent_Insufficient_Access_Rights, (String)Messages.GroupTabContent_Not_Allowed_To_List_Groups);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
                return groups.toArray(new ACGroup[groups.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getTableViewer().refresh();
    }
}

