/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.CreateTagDialog;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESBranchInfo;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESTagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIAddTagController
extends AbstractEMFStoreUIController<Void> {
    private final ESHistoryInfo historyInfo;
    private final ESLocalProject localProject;

    public UIAddTagController(Shell shell, ESLocalProject localProject, ESHistoryInfo historyInfo) {
        super(shell);
        this.localProject = localProject;
        this.historyInfo = historyInfo;
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        CreateTagDialog dialog = this.createDialog(this.getShell(), this.localProject.getBranches(monitor));
        String tagName = "";
        BranchInfo branchInfo = null;
        while (StringUtils.isBlank((String)tagName) || branchInfo == null) {
            if (dialog.open() != 0) {
                return null;
            }
            tagName = dialog.getTagName();
            branchInfo = dialog.getResult();
            if (branchInfo == null) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"No branch selected", (String)"No branch has been selected. Please select the branch should be tagged.");
                continue;
            }
            if (!StringUtils.isBlank((String)tagName)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Empty tag name", (String)"No tag name has been given. Please enter the name of the tag.");
        }
        String branchName = branchInfo.getName();
        ESPrimaryVersionSpec primaryVersion = this.historyInfo.getPrimarySpec();
        ESTagVersionSpec tag = ESVersionSpec.FACTORY.createTAG(tagName, branchName);
        try {
            this.localProject.addTag(primaryVersion, tag, monitor);
        }
        catch (ESException e) {
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.UIAddTagController_ErrorTitle, (String)(String.valueOf(Messages.UIAddTagController_ErrorReason) + e.getMessage()));
            return null;
        }
        this.historyInfo.getTagSpecs().add(tag);
        return null;
    }

    private CreateTagDialog createDialog(Shell shell, List<ESBranchInfo> branches) {
        List internalBranches = APIUtil.toInternal(branches);
        return new CreateTagDialog(shell, internalBranches);
    }
}

