/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.CancelOperationException;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.BranchSelectionDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.CreateProjectDialog;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESBranchInfo;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICheckoutController
extends AbstractEMFStoreUIController<ESLocalProject> {
    private ESUsersession session;
    private ESPrimaryVersionSpec versionSpec;
    private ESRemoteProject remoteProject;
    private boolean askForBranch;

    public UICheckoutController(Shell shell, ESRemoteProject remoteProject) {
        super(shell, false, true);
        this.remoteProject = remoteProject;
        this.askForBranch = false;
        this.versionSpec = null;
    }

    public UICheckoutController(Shell shell, ESRemoteProject remoteProject, boolean askForBranch) {
        this(shell, remoteProject);
        this.askForBranch = askForBranch;
    }

    public UICheckoutController(Shell shell, ESPrimaryVersionSpec versionSpec, ESRemoteProject remoteProject) {
        this(shell, remoteProject);
        this.versionSpec = versionSpec;
    }

    public UICheckoutController(Shell shell, ESPrimaryVersionSpec versionSpec, ESRemoteProject remoteProject, boolean askForBranch) {
        this(shell, versionSpec, remoteProject);
        this.askForBranch = askForBranch;
    }

    public UICheckoutController(Shell shell, ESUsersession session, ESRemoteProject remoteProject) {
        this(shell, remoteProject);
        this.session = session;
    }

    public UICheckoutController(Shell shell, ESUsersession session, ESRemoteProject remoteProject, boolean askForBranch) {
        this(shell, session, remoteProject);
        this.askForBranch = askForBranch;
    }

    public UICheckoutController(Shell shell, ESPrimaryVersionSpec versionSpec, ESUsersession session, ESRemoteProject remoteProject) {
        this(shell, versionSpec, remoteProject);
        this.session = session;
    }

    public UICheckoutController(Shell shell, ESPrimaryVersionSpec versionSpec, ESUsersession session, ESRemoteProject remoteProject, boolean askForBranch) {
        this(shell, versionSpec, session, remoteProject);
        this.askForBranch = askForBranch;
    }

    @Override
    public ESLocalProject doRun(IProgressMonitor progressMonitor) throws ESException {
        String checkedoutProjectName;
        block8: {
            try {
                checkedoutProjectName = RunInUI.runWithResult(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        CreateProjectDialog projectDialog = new CreateProjectDialog(UICheckoutController.this.getShell(), MessageFormat.format("Please provide a name for the checkout of the project {0}", UICheckoutController.this.remoteProject.getProjectName()));
                        if (projectDialog.open() != 0) {
                            return null;
                        }
                        return projectDialog.getName();
                    }
                });
                if (checkedoutProjectName != null) break block8;
                return null;
            }
            catch (ESException e) {
                if (e instanceof CancelOperationException) {
                    return null;
                }
                RunInUI.run(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
                        MessageDialog.openError((Shell)UICheckoutController.this.getShell(), (String)"Checkout failed", (String)("Checkout of project " + UICheckoutController.this.remoteProject.getProjectName() + " failed: " + e.getMessage()));
                        return null;
                    }
                });
                return null;
            }
        }
        if (this.askForBranch && this.versionSpec == null) {
            this.versionSpec = this.branchSelection(this.remoteProject, progressMonitor);
        }
        if (this.session != null) {
            if (this.versionSpec == null) {
                return this.remoteProject.checkout(checkedoutProjectName, this.session, progressMonitor);
            }
            return this.remoteProject.checkout(checkedoutProjectName, this.session, this.versionSpec, progressMonitor);
        }
        if (this.versionSpec == null) {
            return this.remoteProject.checkout(checkedoutProjectName, progressMonitor);
        }
        return this.remoteProject.checkout(checkedoutProjectName, this.remoteProject.getServer().getLastUsersession(), this.versionSpec, progressMonitor);
    }

    private ESPrimaryVersionSpec branchSelection(ESRemoteProject remoteProject, IProgressMonitor monitor) throws ESException {
        final List branches = this.session != null ? remoteProject.getBranches(this.session, monitor) : remoteProject.getBranches(monitor);
        BranchInfo result = RunInUI.WithException.runWithResult(new Callable<BranchInfo>(){

            @Override
            public BranchInfo call() throws Exception {
                List internal = APIUtil.toInternal(BranchInfo.class, (List)branches);
                BranchSelectionDialog.CheckoutSelection dialog = new BranchSelectionDialog.CheckoutSelection(UICheckoutController.this.getShell(), internal);
                dialog.setBlockOnOpen(true);
                if (dialog.open() != 0 || dialog.getResult() == null) {
                    throw new CancelOperationException("No Branch specified");
                }
                return dialog.getResult();
            }
        });
        return ((ESBranchInfo)result.toAPI()).getHead();
    }
}

