/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.emfstore.common.ESSafeRunnable;
import org.eclipse.emf.emfstore.common.ESSafeRunner;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

public class EMFStoreCommandNotifier {
    private List<CommandObserver> commandObservers = new ArrayList<CommandObserver>();

    public void notifiyListenersAboutStart(final Command command) {
        for (final CommandObserver commandObservers : this.commandObservers) {
            ESSafeRunnable code = new ESSafeRunnable(){

                public void run() {
                    commandObservers.commandStarted(command);
                }

                public void handleException(Throwable exception) {
                    ModelUtil.logWarning((String)"Command Observer threw exception", (Throwable)exception);
                }
            };
            ESSafeRunner.run((ESSafeRunnable)code);
        }
    }

    public void notifiyListenersAboutCommandFailed(final Command command, final Exception exception) {
        for (final CommandObserver commandObservers : this.commandObservers) {
            ESSafeRunnable code = new ESSafeRunnable(){

                public void run() {
                    commandObservers.commandFailed(command, exception);
                }

                public void handleException(Throwable exception2) {
                    ModelUtil.logWarning((String)"Command Observer threw exception", (Throwable)exception2);
                }
            };
            ESSafeRunner.run((ESSafeRunnable)code);
        }
    }

    public void notifiyListenersAboutCommandCompleted(final Command command) {
        for (final CommandObserver commandObservers : this.commandObservers) {
            ESSafeRunnable code = new ESSafeRunnable(){

                public void run() {
                    commandObservers.commandCompleted(command);
                }

                public void handleException(Throwable exception) {
                    ModelUtil.logWarning((String)"Command Observer threw exception", (Throwable)exception);
                }
            };
            ESSafeRunner.run((ESSafeRunnable)code);
        }
    }

    public void addCommandStackObserver(CommandObserver observer) {
        this.commandObservers.add(observer);
    }

    public void removeCommandStackObserver(CommandObserver observer) {
        this.commandObservers.remove(observer);
    }
}

