/*******************************************************************************
 * Copyright (c) 2012-2013 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * wesendon
 * emueller
 ******************************************************************************/
package org.eclipse.emf.emfstore.internal.client.ui.handlers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIShowHistoryController;

/**
 * Brings up the history view for a selected {@link EObject}<br/>
 * If the {@link EObject} is a ProjectSpace the complete history is shown.
 * 
 * @author emueller
 * @author wesendon
 * 
 */
public class ShowHistoryHandler extends AbstractEMFStoreHandler {

	@Override
	public void handle() {
		new UIShowHistoryController(getShell(), requireSelection(EObject.class)).execute();
	}

}
