/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.epackage.IProxyEClass;
import org.eclipse.egf.core.epackage.IProxyEClassifier;
import org.eclipse.egf.core.epackage.IProxyEDataType;
import org.eclipse.egf.core.epackage.IProxyEObject;
import org.eclipse.egf.core.epackage.IProxyEPackage;
import org.eclipse.egf.core.epackage.IProxyERoot;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.ISelectionDialogListener;
import org.eclipse.egf.core.ui.dialogs.TargetPlatformEcoreDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class TargetPlatformEcoreSelectionDialog
extends SelectionStatusDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.core.ui.dialogs.TargetPlatformEcoreSelectionDialog";
    private static final String SHOW_STATUS_LINE = "ShowStatusLine";
    private ExtendedImageRegistry registry = ExtendedImageRegistry.INSTANCE;
    private static final String EMPTY_STRING = "";
    private MenuManager _menuManager;
    private ToolBar _toolBar;
    private ToolItem _toolItem;
    private boolean _multi;
    protected TreeViewer _ecoreTypeTreeViewer;
    private IStatus _status;
    private Object[] _currentSelection;
    private DetailsContentViewer _details;
    private ToggleStatusLineAction _toggleStatusLineAction;
    private IHandlerActivation _showViewHandler;
    private ILabelProvider _detailsLabelProvider;
    private List<ISelectionDialogListener> _selectionListeners = new UniqueEList();

    public TargetPlatformEcoreSelectionDialog(Shell shell, boolean multi) {
        super(shell);
        this._multi = multi;
    }

    public TargetPlatformEcoreSelectionDialog(Shell shell) {
        this(shell, false);
    }

    protected void restoreDialog(IDialogSettings settings) {
        boolean toggleStatusLine = true;
        if (settings.get(SHOW_STATUS_LINE) != null) {
            toggleStatusLine = settings.getBoolean(SHOW_STATUS_LINE);
        }
        this._toggleStatusLineAction.setChecked(toggleStatusLine);
        this._details.setVisible(toggleStatusLine);
    }

    protected void storeDialog(IDialogSettings settings) {
        settings.put(SHOW_STATUS_LINE, this._toggleStatusLineAction.isChecked());
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = EGFCoreUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = EGFCoreUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public boolean close() {
        if (this._showViewHandler != null) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            service.deactivateHandler(this._showViewHandler);
            this._showViewHandler.getHandler().dispose();
            this._showViewHandler = null;
        }
        this.storeDialog(this.getDialogSettings());
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        content.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.createHeader(content);
        Composite viewer = new Composite(content, 0);
        viewer.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        viewer.setLayout((Layout)layout);
        Tree tree = new Tree(viewer, 0xB00 | (this._multi ? 2 : 4));
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 11;
        tree.setLayoutData((Object)gd);
        this._ecoreTypeTreeViewer = new TreeViewer(tree);
        this._ecoreTypeTreeViewer.setContentProvider((IContentProvider)new EcoreContentProvider());
        this._ecoreTypeTreeViewer.setLabelProvider((IBaseLabelProvider)new EcoreLabelProvider());
        this._ecoreTypeTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IProxyEObject) {
                    if (element instanceof IProxyEClassifier) {
                        return 2;
                    }
                    if (element instanceof IProxyEPackage) {
                        return 1;
                    }
                }
                return 10;
            }
        });
        this._ecoreTypeTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer innerViewer, Object parentElement, Object element) {
                return element instanceof IProxyERoot || element instanceof IProxyEClass || element instanceof IProxyEPackage;
            }
        });
        this._ecoreTypeTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                TargetPlatformEcoreSelectionDialog.this.handleSelected(selection);
            }
        });
        this._ecoreTypeTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TargetPlatformEcoreSelectionDialog.this.handleDoubleClick();
            }
        });
        Button button = new Button(viewer, 8);
        button.setText(CoreUIMessages.TargetPlatformEcoreSelectionDialog_choose_model_button_title);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TargetPlatformEcoreDialog chooseModelDialog = new TargetPlatformEcoreDialog(TargetPlatformEcoreSelectionDialog.this.getShell(), true, false, TargetPlatformEcoreSelectionDialog.this._multi, false, false);
                if (chooseModelDialog.open() == 0) {
                    TargetPlatformEcoreSelectionDialog.this.searchTypeModel(chooseModelDialog.getURIText());
                }
            }
        });
        this._details = new DetailsContentViewer(content, 0x800800);
        this._details.setVisible(this._toggleStatusLineAction.isChecked());
        this._details.setContentProvider(new NullContentProvider());
        this._details.setLabelProvider((IBaseLabelProvider)this.getDetailsLabelProvider());
        TargetPlatformEcoreSelectionDialog.applyDialogFont((Control)content);
        this.restoreDialog(this.getDialogSettings());
        return container;
    }

    private Label createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        Label headerLabel = new Label(header, 0);
        headerLabel.setText(this.getMessage() != null && this.getMessage().trim().length() > 0 ? this.getMessage() : CoreUIMessages.TargetPlatformEcoreSelectionDialog_select);
        GridData gd = new GridData(768);
        headerLabel.setLayoutData((Object)gd);
        this.createViewMenu(header);
        header.setLayoutData((Object)gd);
        return headerLabel;
    }

    private void createViewMenu(Composite parent) {
        this._toolBar = new ToolBar(parent, 0x800000);
        this._toolItem = new ToolItem(this._toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this._toolBar.setLayoutData((Object)data);
        this._toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TargetPlatformEcoreSelectionDialog.this.showViewMenu();
            }
        });
        this._toolItem.setImage(EGFCoreUIPlugin.getDefault().getImage("obj16/view_menu.gif"));
        this._toolItem.setToolTipText(CoreUIMessages.TargetPlatformEcoreSelectionDialog_menu);
        this._toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformEcoreSelectionDialog.this.showViewMenu();
            }
        });
        this._menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this._menuManager);
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                TargetPlatformEcoreSelectionDialog.this.showViewMenu();
                return null;
            }
        };
        this._showViewHandler = service.activateHandler("org.eclipse.egf.core.ui.dialogs.EcoreSelectionDialog", (IHandler)handler, (Expression)new ActiveShellExpression(this.getShell()));
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        this._toggleStatusLineAction = new ToggleStatusLineAction();
        menuManager.add((IAction)this._toggleStatusLineAction);
    }

    private void showViewMenu() {
        Menu menu = this._menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this._toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this._toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    public void setDetailsLabelProvider(ILabelProvider detailsLabelProvider) {
        this._detailsLabelProvider = detailsLabelProvider;
        if (this._details != null) {
            this._details.setLabelProvider((IBaseLabelProvider)detailsLabelProvider);
        }
    }

    private ILabelProvider getDetailsLabelProvider() {
        if (this._detailsLabelProvider == null) {
            this._detailsLabelProvider = new EcoreDetailsLabelProvider();
        }
        return this._detailsLabelProvider;
    }

    protected void computeResult() {
        List selectedElements = ((StructuredSelection)this._ecoreTypeTreeViewer.getSelection()).toList();
        ArrayList<String> objectsToReturn = new ArrayList<String>();
        for (Object object : selectedElements) {
            URI uri = null;
            if (object instanceof IProxyEObject) {
                uri = ((IProxyEObject)object).getURI();
            }
            if (uri == null || uri.isEmpty() || "#//".equals(uri.toString())) continue;
            objectsToReturn.add(uri.toString());
        }
        this.setResult(objectsToReturn);
    }

    protected void searchTypeModel(String buffer) {
        if (buffer == null || buffer.trim().length() == 0) {
            return;
        }
        String[] textUris = buffer.split("  ");
        IProxyERoot root = null;
        String[] stringArray = textUris;
        int n = textUris.length;
        int n2 = 0;
        while (n2 < n) {
            String textUri = stringArray[n2];
            try {
                URI uri;
                if (textUri != null && textUri.trim().length() != 0 && (root = EGFCorePlugin.getTargetPlatformIProxyERoot((URI)(uri = URI.createURI((String)textUri.trim())))) != null) {
                    break;
                }
            }
            catch (Throwable t) {
                EGFCoreUIPlugin.getDefault().logError(NLS.bind((String)CoreUIMessages.ModelSelection_errorMessage, (Object)textUri));
            }
            ++n2;
        }
        if (root != null) {
            this._ecoreTypeTreeViewer.setInput(root);
            this._ecoreTypeTreeViewer.expandToLevel(2);
        }
    }

    protected void handleSelected(StructuredSelection selection) {
        Status status = new Status(0, EGFCoreUIPlugin.getDefault().getPluginID(), 0, EMPTY_STRING, null);
        Object[] lastSelection = this._currentSelection;
        this._currentSelection = selection.toArray();
        if (selection.size() == 0) {
            status = new Status(4, EGFCoreUIPlugin.getDefault().getPluginID(), 4, EMPTY_STRING, null);
            if (lastSelection != null) {
                this._ecoreTypeTreeViewer.update(lastSelection, null);
            }
            this._currentSelection = null;
        } else {
            status = new Status(4, EGFCoreUIPlugin.getDefault().getPluginID(), 4, EMPTY_STRING, null);
            List items = selection.toList();
            IStatus tempStatus = null;
            for (Object item : items) {
                tempStatus = this.validateItem(item);
                if (tempStatus.isOK()) {
                    status = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
                    continue;
                }
                status = tempStatus;
                break;
            }
            this.notifySelectionListeners(items.toArray());
            if (lastSelection != null) {
                this._ecoreTypeTreeViewer.update(lastSelection, null);
            }
        }
        this.refreshDetails();
        this.updateStatus((IStatus)status);
    }

    protected void updateStatus(IStatus status) {
        this._status = status;
        super.updateStatus(status);
    }

    protected void okPressed() {
        if (this._status != null && (this._status.isOK() || this._status.getCode() == 1)) {
            super.okPressed();
        }
    }

    public Shell getShell() {
        return super.getShell() != null ? super.getShell() : this.getParentShell();
    }

    protected void handleDoubleClick() {
        this.okPressed();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, EGFCoreUIPlugin.getDefault().getPluginID(), 0, EMPTY_STRING, null);
    }

    protected StructuredSelection getSelectedItems() {
        return new StructuredSelection(((StructuredSelection)this._ecoreTypeTreeViewer.getSelection()).toList());
    }

    private void refreshDetails() {
        StructuredSelection selection = this.getSelectedItems();
        switch (selection.size()) {
            case 0: {
                this._details.setInput(null);
                break;
            }
            case 1: {
                this._details.setInput(selection.getFirstElement());
                break;
            }
            default: {
                this._details.setInput(NLS.bind((String)CoreUIMessages.TargetPlatformEcoreSelectionDialog_nItemsSelected, (Object)new Integer(selection.size())));
            }
        }
    }

    public Control createPage(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        return this.dialogArea;
    }

    public boolean addSelectionListeners(ISelectionDialogListener listener) {
        if (listener == null) {
            return false;
        }
        return this._selectionListeners.add(listener);
    }

    public boolean removeSelectionListeners(ISelectionDialogListener listener) {
        if (listener == null) {
            return false;
        }
        return this._selectionListeners.remove(listener);
    }

    public void notifySelectionListeners(Object[] selected) {
        for (ISelectionDialogListener listener : this._selectionListeners) {
            listener.handleSelected(selected);
        }
    }

    private class DetailsContentViewer
    extends ContentViewer {
        private CLabel label;
        private ViewForm viewForm;

        public DetailsContentViewer(Composite parent, int style) {
            this.viewForm = new ViewForm(parent, style);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.viewForm.setLayoutData((Object)gd);
            this.label = new CLabel((Composite)this.viewForm, 0x800000);
            this.label.setFont(parent.getFont());
            this.viewForm.setContent((Control)this.label);
            this.hookControl((Control)this.label);
        }

        public void setVisible(boolean visible) {
            GridData gd = (GridData)this.viewForm.getLayoutData();
            gd.exclude = !visible;
            this.viewForm.getParent().layout();
        }

        protected void inputChanged(Object input, Object oldInput) {
            if (oldInput == null) {
                if (input == null) {
                    return;
                }
                this.refresh();
                return;
            }
            this.refresh();
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            if (event != null) {
                this.refresh(event.getElements());
            }
        }

        public Control getControl() {
            return this.label;
        }

        public ISelection getSelection() {
            return null;
        }

        public void refresh() {
            Object input = this.getInput();
            if (input != null) {
                ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                this.doRefresh(labelProvider.getText(input), labelProvider.getImage(input));
            } else {
                this.doRefresh(null, null);
            }
        }

        private void doRefresh(String text, Image image) {
            this.label.setText(text);
            this.label.setImage(image);
        }

        public void setSelection(ISelection selection, boolean reveal) {
        }

        private void refresh(Object[] objs) {
            if (objs == null || this.getInput() == null) {
                return;
            }
            Object input = this.getInput();
            int i = 0;
            while (i < objs.length) {
                if (objs[i].equals(input)) {
                    this.refresh();
                    break;
                }
                ++i;
            }
        }
    }

    protected class EcoreContentProvider
    implements ITreeContentProvider {
        protected EcoreContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof IProxyEObject) {
                return ((IProxyEObject)element).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProxyERoot) {
                IProxyERoot wrapper = (IProxyERoot)parentElement;
                return wrapper.getChildren();
            }
            if (parentElement instanceof IProxyEPackage) {
                IProxyEPackage wrapper = (IProxyEPackage)parentElement;
                return wrapper.getChildren();
            }
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            return new Object[0];
        }
    }

    private class EcoreDetailsLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof IProxyEPackage) {
                return TargetPlatformEcoreSelectionDialog.this.registry.getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
            }
            if (element instanceof IProxyEClass) {
                return TargetPlatformEcoreSelectionDialog.this.registry.getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EClass"));
            }
            if (element instanceof IProxyEDataType) {
                return TargetPlatformEcoreSelectionDialog.this.registry.getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EDataType"));
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IProxyEObject) {
                return ((IProxyEObject)element).getURI().toString();
            }
            return TargetPlatformEcoreSelectionDialog.EMPTY_STRING;
        }
    }

    protected class EcoreLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IProxyEPackage) {
                return TargetPlatformEcoreSelectionDialog.this.registry.getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
            }
            if (element instanceof IProxyEClass) {
                return TargetPlatformEcoreSelectionDialog.this.registry.getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EClass"));
            }
            if (element instanceof IProxyEDataType) {
                return TargetPlatformEcoreSelectionDialog.this.registry.getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EDataType"));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IProxyEObject) {
                return ((IProxyEObject)element).getName();
            }
            return TargetPlatformEcoreSelectionDialog.EMPTY_STRING;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private class NullContentProvider
    implements IContentProvider {
        private NullContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ToggleStatusLineAction
    extends Action {
        public ToggleStatusLineAction() {
            super(CoreUIMessages.TargetPlatformEcoreSelectionDialog_toggleStatusAction, 2);
        }

        public void run() {
            TargetPlatformEcoreSelectionDialog.this._details.setVisible(this.isChecked());
        }
    }
}

