/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message;

import javax.security.auth.message.MessageInfo;

public class MessagePolicy {
    private TargetPolicy[] targetPolicies;
    private boolean mandatory;

    public MessagePolicy(TargetPolicy[] targetPolicies, boolean mandatory) {
        if (targetPolicies == null) {
            throw new IllegalArgumentException("invalid null targetPolicies");
        }
        this.targetPolicies = (TargetPolicy[])targetPolicies.clone();
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public TargetPolicy[] getTargetPolicies() {
        return (TargetPolicy[])this.targetPolicies.clone();
    }

    public static interface ProtectionPolicy {
        public static final String AUTHENTICATE_SENDER = "#authenticateSender";
        public static final String AUTHENTICATE_CONTENT = "#authenticateContent";
        public static final String AUTHENTICATE_RECIPIENT = "#authenticateRecipient";

        public String getID();
    }

    public static interface Target {
        public Object get(MessageInfo var1);

        public void remove(MessageInfo var1);

        public void put(MessageInfo var1, Object var2);
    }

    public static class TargetPolicy {
        private Target[] targets;
        private ProtectionPolicy protectionPolicy;

        public TargetPolicy(Target[] targets, ProtectionPolicy protectionPolicy) {
            if (protectionPolicy == null) {
                throw new IllegalArgumentException("invalid null protectionPolicy");
            }
            this.targets = targets == null || targets.length == 0 ? null : (Target[])targets.clone();
            this.protectionPolicy = protectionPolicy;
        }

        public Target[] getTargets() {
            return this.targets;
        }

        public ProtectionPolicy getProtectionPolicy() {
            return this.protectionPolicy;
        }
    }
}

